/*
 * Decompiled with CFR 0.152.
 */
package io.minio;

import io.minio.BucketArgs;
import io.minio.ServerSideEncryption;
import okhttp3.HttpUrl;

public abstract class ObjectArgs
extends BucketArgs {
    protected String objectName;

    public String object() {
        return this.objectName;
    }

    protected void checkSse(ServerSideEncryption sse, HttpUrl url) {
        if (sse == null) {
            return;
        }
        if (sse.type().requiresTls() && !url.isHttps()) {
            throw new IllegalArgumentException(sse.type().name() + " operations must be performed over a secure connection.");
        }
    }

    public static abstract class Builder<B extends Builder<B, A>, A extends ObjectArgs>
    extends BucketArgs.Builder<B, A> {
        protected void validateObjectName(String name) {
            this.validateNotEmptyString(name, "object name");
        }

        @Override
        protected void validate(A args) {
            super.validate(args);
            this.validateObjectName(((ObjectArgs)args).objectName);
        }

        public B object(String name) {
            this.validateObjectName(name);
            this.operations.add(args -> {
                args.objectName = name;
            });
            return (B)this;
        }
    }
}

