/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.minio;

import io.minio.MinioClient;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.component.minio.MinioComponentVerifierExtension;
import org.apache.camel.component.minio.MinioConfiguration;
import org.apache.camel.component.minio.MinioEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@org.apache.camel.spi.annotations.Component(value="minio")
public class MinioComponent
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(MinioComponent.class);
    @Metadata
    private MinioConfiguration configuration = new MinioConfiguration();

    public MinioComponent() {
        this(null);
    }

    public MinioComponent(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new MinioComponentVerifierExtension());
    }

    protected MinioEndpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (ObjectHelper.isEmpty((Object)remaining) || remaining.trim().length() == 0) {
            throw new IllegalArgumentException("Bucket name must be specified.");
        }
        MinioConfiguration configuration = ObjectHelper.isNotEmpty((Object)this.configuration) ? this.configuration.copy() : new MinioConfiguration();
        configuration.setBucketName(remaining);
        MinioEndpoint endpoint = new MinioEndpoint(uri, (Component)this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        this.checkAndSetRegistryClient(configuration, endpoint);
        return endpoint;
    }

    public MinioConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(MinioConfiguration configuration) {
        this.configuration = configuration;
    }

    private void checkAndSetRegistryClient(MinioConfiguration configuration, MinioEndpoint endpoint) {
        if (ObjectHelper.isEmpty((Object)endpoint.getConfiguration().getMinioClient())) {
            LOG.debug("Looking for an MinioClient instance in the registry");
            Set clients = this.getCamelContext().getRegistry().findByType(MinioClient.class);
            if (clients.size() > 1) {
                LOG.debug("Found more than one MinioClient instance in the registry");
            } else if (clients.size() == 1) {
                LOG.debug("Found exactly one MinioClient instance in the registry");
                configuration.setMinioClient((MinioClient)clients.stream().findFirst().get());
            } else {
                LOG.debug("No MinioClient instance in the registry");
            }
        } else {
            LOG.debug("MinioClient instance is already set at endpoint level: skipping the check in the registry");
        }
    }
}

