/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.binaryschema;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Struct {
    private final String name;
    private final ImmutableMap<String, Member> members;

    public Struct(@Nonnull String name, @Nonnull Map<String, Member> members) {
        this(name, (ImmutableMap<String, Member>)ImmutableMap.copyOf(members));
    }

    public Struct(@Nonnull String name, @Nonnull ImmutableMap<String, Member> members) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull(members);
        this.name = name;
        this.members = members;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public ImmutableMap<String, Member> getMembers() {
        return this.members;
    }

    @Nullable
    public Member getMember(String name) {
        return (Member)this.members.get((Object)name);
    }

    @Nonnull
    public Optional<Member> getMemberSafe(String name) {
        return Optional.ofNullable(this.members.get((Object)name));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Struct that = (Struct)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.members, that.members);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.members);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("members", this.members).toString();
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public static class Builder {
        private final String name;
        private final LinkedList<Member> members = new LinkedList();

        public Builder(String name) {
            this.name = name;
        }

        public Builder addMember(String name, Object value) {
            Preconditions.checkArgument((!(value instanceof Member) ? 1 : 0) != 0);
            this.members.add(new Member(name, value));
            return this;
        }

        public Struct build() {
            ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
            this.members.forEach(m -> mapBuilder.put((Object)((Member)m).name, m));
            return new Struct(this.name, (ImmutableMap<String, Member>)mapBuilder.build());
        }
    }

    public static class Member {
        private final String name;
        private final Object value;

        public Member(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Member member = (Member)o;
            if (this.value != null && this.value.getClass().isArray()) {
                return Objects.equals(this.name, member.name) && Objects.deepEquals(this.value, member.value);
            }
            return Objects.equals(this.name, member.name) && Objects.equals(this.value, member.value);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.value);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("value", this.value).toString();
        }
    }
}

