/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;

public class RegisterServer2Response
implements UaResponseMessage {
    public static final NodeId TypeId = Identifiers.RegisterServer2Response;
    public static final NodeId BinaryEncodingId = Identifiers.RegisterServer2Response_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.RegisterServer2Response_Encoding_DefaultXml;
    protected final ResponseHeader responseHeader;
    protected final StatusCode[] configurationResults;
    protected final DiagnosticInfo[] diagnosticInfos;

    public RegisterServer2Response() {
        this.responseHeader = null;
        this.configurationResults = null;
        this.diagnosticInfos = null;
    }

    public RegisterServer2Response(ResponseHeader responseHeader, StatusCode[] configurationResults, DiagnosticInfo[] diagnosticInfos) {
        this.responseHeader = responseHeader;
        this.configurationResults = configurationResults;
        this.diagnosticInfos = diagnosticInfos;
    }

    @Override
    public ResponseHeader getResponseHeader() {
        return this.responseHeader;
    }

    @Nullable
    public StatusCode[] getConfigurationResults() {
        return this.configurationResults;
    }

    @Nullable
    public DiagnosticInfo[] getDiagnosticInfos() {
        return this.diagnosticInfos;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ResponseHeader", (Object)this.responseHeader).add("ConfigurationResults", (Object)this.configurationResults).add("DiagnosticInfos", (Object)this.diagnosticInfos).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<RegisterServer2Response> {
        @Override
        public Class<RegisterServer2Response> getType() {
            return RegisterServer2Response.class;
        }

        @Override
        public RegisterServer2Response decode(UaDecoder decoder) throws UaSerializationException {
            ResponseHeader responseHeader = decoder.readBuiltinStruct("ResponseHeader", ResponseHeader.class);
            StatusCode[] configurationResults = decoder.readArray("ConfigurationResults", decoder::readStatusCode, StatusCode.class);
            DiagnosticInfo[] diagnosticInfos = decoder.readArray("DiagnosticInfos", decoder::readDiagnosticInfo, DiagnosticInfo.class);
            return new RegisterServer2Response(responseHeader, configurationResults, diagnosticInfos);
        }

        @Override
        public void encode(RegisterServer2Response value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeBuiltinStruct("ResponseHeader", value.responseHeader, ResponseHeader.class);
            encoder.writeArray("ConfigurationResults", value.configurationResults, encoder::writeStatusCode);
            encoder.writeArray("DiagnosticInfos", value.diagnosticInfos, encoder::writeDiagnosticInfo);
        }
    }
}

