/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;

public class QueryDataSet
implements UaStructure {
    public static final NodeId TypeId = Identifiers.QueryDataSet;
    public static final NodeId BinaryEncodingId = Identifiers.QueryDataSet_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.QueryDataSet_Encoding_DefaultXml;
    protected final ExpandedNodeId nodeId;
    protected final ExpandedNodeId typeDefinitionNode;
    protected final Variant[] values;

    public QueryDataSet() {
        this.nodeId = null;
        this.typeDefinitionNode = null;
        this.values = null;
    }

    public QueryDataSet(ExpandedNodeId nodeId, ExpandedNodeId typeDefinitionNode, Variant[] values) {
        this.nodeId = nodeId;
        this.typeDefinitionNode = typeDefinitionNode;
        this.values = values;
    }

    public ExpandedNodeId getNodeId() {
        return this.nodeId;
    }

    public ExpandedNodeId getTypeDefinitionNode() {
        return this.typeDefinitionNode;
    }

    @Nullable
    public Variant[] getValues() {
        return this.values;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("NodeId", (Object)this.nodeId).add("TypeDefinitionNode", (Object)this.typeDefinitionNode).add("Values", (Object)this.values).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<QueryDataSet> {
        @Override
        public Class<QueryDataSet> getType() {
            return QueryDataSet.class;
        }

        @Override
        public QueryDataSet decode(UaDecoder decoder) throws UaSerializationException {
            ExpandedNodeId nodeId = decoder.readExpandedNodeId("NodeId");
            ExpandedNodeId typeDefinitionNode = decoder.readExpandedNodeId("TypeDefinitionNode");
            Variant[] values = decoder.readArray("Values", decoder::readVariant, Variant.class);
            return new QueryDataSet(nodeId, typeDefinitionNode, values);
        }

        @Override
        public void encode(QueryDataSet value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeExpandedNodeId("NodeId", value.nodeId);
            encoder.writeExpandedNodeId("TypeDefinitionNode", value.typeDefinitionNode);
            encoder.writeArray("Values", value.values, encoder::writeVariant);
        }
    }
}

