/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.ChannelSecurityToken;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;

public class OpenSecureChannelResponse
implements UaResponseMessage {
    public static final NodeId TypeId = Identifiers.OpenSecureChannelResponse;
    public static final NodeId BinaryEncodingId = Identifiers.OpenSecureChannelResponse_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.OpenSecureChannelResponse_Encoding_DefaultXml;
    protected final ResponseHeader responseHeader;
    protected final UInteger serverProtocolVersion;
    protected final ChannelSecurityToken securityToken;
    protected final ByteString serverNonce;

    public OpenSecureChannelResponse() {
        this.responseHeader = null;
        this.serverProtocolVersion = null;
        this.securityToken = null;
        this.serverNonce = null;
    }

    public OpenSecureChannelResponse(ResponseHeader responseHeader, UInteger serverProtocolVersion, ChannelSecurityToken securityToken, ByteString serverNonce) {
        this.responseHeader = responseHeader;
        this.serverProtocolVersion = serverProtocolVersion;
        this.securityToken = securityToken;
        this.serverNonce = serverNonce;
    }

    @Override
    public ResponseHeader getResponseHeader() {
        return this.responseHeader;
    }

    public UInteger getServerProtocolVersion() {
        return this.serverProtocolVersion;
    }

    public ChannelSecurityToken getSecurityToken() {
        return this.securityToken;
    }

    public ByteString getServerNonce() {
        return this.serverNonce;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ResponseHeader", (Object)this.responseHeader).add("ServerProtocolVersion", (Object)this.serverProtocolVersion).add("SecurityToken", (Object)this.securityToken).add("ServerNonce", (Object)this.serverNonce).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<OpenSecureChannelResponse> {
        @Override
        public Class<OpenSecureChannelResponse> getType() {
            return OpenSecureChannelResponse.class;
        }

        @Override
        public OpenSecureChannelResponse decode(UaDecoder decoder) throws UaSerializationException {
            ResponseHeader responseHeader = decoder.readBuiltinStruct("ResponseHeader", ResponseHeader.class);
            UInteger serverProtocolVersion = decoder.readUInt32("ServerProtocolVersion");
            ChannelSecurityToken securityToken = decoder.readBuiltinStruct("SecurityToken", ChannelSecurityToken.class);
            ByteString serverNonce = decoder.readByteString("ServerNonce");
            return new OpenSecureChannelResponse(responseHeader, serverProtocolVersion, securityToken, serverNonce);
        }

        @Override
        public void encode(OpenSecureChannelResponse value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeBuiltinStruct("ResponseHeader", value.responseHeader, ResponseHeader.class);
            encoder.writeUInt32("ServerProtocolVersion", value.serverProtocolVersion);
            encoder.writeBuiltinStruct("SecurityToken", value.securityToken, ChannelSecurityToken.class);
            encoder.writeByteString("ServerNonce", value.serverNonce);
        }
    }
}

