/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;

public class MonitoredItemModifyResult
implements UaStructure {
    public static final NodeId TypeId = Identifiers.MonitoredItemModifyResult;
    public static final NodeId BinaryEncodingId = Identifiers.MonitoredItemModifyResult_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.MonitoredItemModifyResult_Encoding_DefaultXml;
    protected final StatusCode statusCode;
    protected final Double revisedSamplingInterval;
    protected final UInteger revisedQueueSize;
    protected final ExtensionObject filterResult;

    public MonitoredItemModifyResult() {
        this.statusCode = null;
        this.revisedSamplingInterval = null;
        this.revisedQueueSize = null;
        this.filterResult = null;
    }

    public MonitoredItemModifyResult(StatusCode statusCode, Double revisedSamplingInterval, UInteger revisedQueueSize, ExtensionObject filterResult) {
        this.statusCode = statusCode;
        this.revisedSamplingInterval = revisedSamplingInterval;
        this.revisedQueueSize = revisedQueueSize;
        this.filterResult = filterResult;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public Double getRevisedSamplingInterval() {
        return this.revisedSamplingInterval;
    }

    public UInteger getRevisedQueueSize() {
        return this.revisedQueueSize;
    }

    public ExtensionObject getFilterResult() {
        return this.filterResult;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("StatusCode", (Object)this.statusCode).add("RevisedSamplingInterval", (Object)this.revisedSamplingInterval).add("RevisedQueueSize", (Object)this.revisedQueueSize).add("FilterResult", (Object)this.filterResult).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<MonitoredItemModifyResult> {
        @Override
        public Class<MonitoredItemModifyResult> getType() {
            return MonitoredItemModifyResult.class;
        }

        @Override
        public MonitoredItemModifyResult decode(UaDecoder decoder) throws UaSerializationException {
            StatusCode statusCode = decoder.readStatusCode("StatusCode");
            Double revisedSamplingInterval = decoder.readDouble("RevisedSamplingInterval");
            UInteger revisedQueueSize = decoder.readUInt32("RevisedQueueSize");
            ExtensionObject filterResult = decoder.readExtensionObject("FilterResult");
            return new MonitoredItemModifyResult(statusCode, revisedSamplingInterval, revisedQueueSize, filterResult);
        }

        @Override
        public void encode(MonitoredItemModifyResult value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeStatusCode("StatusCode", value.statusCode);
            encoder.writeDouble("RevisedSamplingInterval", value.revisedSamplingInterval);
            encoder.writeUInt32("RevisedQueueSize", value.revisedQueueSize);
            encoder.writeExtensionObject("FilterResult", value.filterResult);
        }
    }
}

