/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.ContentFilterElementResult;

public class ContentFilterResult
implements UaStructure {
    public static final NodeId TypeId = Identifiers.ContentFilterResult;
    public static final NodeId BinaryEncodingId = Identifiers.ContentFilterResult_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.ContentFilterResult_Encoding_DefaultXml;
    protected final ContentFilterElementResult[] elementResults;
    protected final DiagnosticInfo[] elementDiagnosticInfos;

    public ContentFilterResult() {
        this.elementResults = null;
        this.elementDiagnosticInfos = null;
    }

    public ContentFilterResult(ContentFilterElementResult[] elementResults, DiagnosticInfo[] elementDiagnosticInfos) {
        this.elementResults = elementResults;
        this.elementDiagnosticInfos = elementDiagnosticInfos;
    }

    @Nullable
    public ContentFilterElementResult[] getElementResults() {
        return this.elementResults;
    }

    @Nullable
    public DiagnosticInfo[] getElementDiagnosticInfos() {
        return this.elementDiagnosticInfos;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ElementResults", (Object)this.elementResults).add("ElementDiagnosticInfos", (Object)this.elementDiagnosticInfos).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<ContentFilterResult> {
        @Override
        public Class<ContentFilterResult> getType() {
            return ContentFilterResult.class;
        }

        @Override
        public ContentFilterResult decode(UaDecoder decoder) throws UaSerializationException {
            ContentFilterElementResult[] elementResults = (ContentFilterElementResult[])decoder.readBuiltinStructArray("ElementResults", ContentFilterElementResult.class);
            DiagnosticInfo[] elementDiagnosticInfos = decoder.readArray("ElementDiagnosticInfos", decoder::readDiagnosticInfo, DiagnosticInfo.class);
            return new ContentFilterResult(elementResults, elementDiagnosticInfos);
        }

        @Override
        public void encode(ContentFilterResult value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeBuiltinStructArray("ElementResults", value.elementResults, ContentFilterElementResult.class);
            encoder.writeArray("ElementDiagnosticInfos", value.elementDiagnosticInfos, encoder::writeDiagnosticInfo);
        }
    }
}

