/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.structured.ReferenceDescription;

public class BrowseResult
implements UaStructure {
    public static final NodeId TypeId = Identifiers.BrowseResult;
    public static final NodeId BinaryEncodingId = Identifiers.BrowseResult_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.BrowseResult_Encoding_DefaultXml;
    protected final StatusCode statusCode;
    protected final ByteString continuationPoint;
    protected final ReferenceDescription[] references;

    public BrowseResult() {
        this.statusCode = null;
        this.continuationPoint = null;
        this.references = null;
    }

    public BrowseResult(StatusCode statusCode, ByteString continuationPoint, ReferenceDescription[] references) {
        this.statusCode = statusCode;
        this.continuationPoint = continuationPoint;
        this.references = references;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public ByteString getContinuationPoint() {
        return this.continuationPoint;
    }

    @Nullable
    public ReferenceDescription[] getReferences() {
        return this.references;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("StatusCode", (Object)this.statusCode).add("ContinuationPoint", (Object)this.continuationPoint).add("References", (Object)this.references).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<BrowseResult> {
        @Override
        public Class<BrowseResult> getType() {
            return BrowseResult.class;
        }

        @Override
        public BrowseResult decode(UaDecoder decoder) throws UaSerializationException {
            StatusCode statusCode = decoder.readStatusCode("StatusCode");
            ByteString continuationPoint = decoder.readByteString("ContinuationPoint");
            ReferenceDescription[] references = (ReferenceDescription[])decoder.readBuiltinStructArray("References", ReferenceDescription.class);
            return new BrowseResult(statusCode, continuationPoint, references);
        }

        @Override
        public void encode(BrowseResult value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeStatusCode("StatusCode", value.statusCode);
            encoder.writeByteString("ContinuationPoint", value.continuationPoint);
            encoder.writeBuiltinStructArray("References", value.references, ReferenceDescription.class);
        }
    }
}

