/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.enumerated;

import com.google.common.collect.ImmutableMap;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEnumeration;

public enum TrustListMasks implements UaEnumeration
{
    None(0),
    TrustedCertificates(1),
    TrustedCrls(2),
    IssuerCertificates(4),
    IssuerCrls(8),
    All(15);

    private final int value;
    private static final ImmutableMap<Integer, TrustListMasks> VALUES;

    private TrustListMasks(int value) {
        this.value = value;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static TrustListMasks from(Integer value) {
        if (value == null) {
            return null;
        }
        return (TrustListMasks)VALUES.getOrDefault((Object)value, null);
    }

    public static void encode(TrustListMasks trustListMasks, UaEncoder encoder) {
        encoder.writeInt32(null, trustListMasks.getValue());
    }

    public static TrustListMasks decode(UaDecoder decoder) {
        int value = decoder.readInt32(null);
        return (TrustListMasks)VALUES.getOrDefault((Object)value, null);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (TrustListMasks e : TrustListMasks.values()) {
            builder.put((Object)e.getValue(), (Object)e);
        }
        VALUES = builder.build();
    }
}

