/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.enumerated;

import com.google.common.collect.ImmutableMap;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEnumeration;

public enum BrowseResultMask implements UaEnumeration
{
    None(0),
    ReferenceTypeId(1),
    IsForward(2),
    NodeClass(4),
    BrowseName(8),
    DisplayName(16),
    TypeDefinition(32),
    All(63),
    ReferenceTypeInfo(3),
    TargetInfo(60);

    private final int value;
    private static final ImmutableMap<Integer, BrowseResultMask> VALUES;

    private BrowseResultMask(int value) {
        this.value = value;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static BrowseResultMask from(Integer value) {
        if (value == null) {
            return null;
        }
        return (BrowseResultMask)VALUES.getOrDefault((Object)value, null);
    }

    public static void encode(BrowseResultMask browseResultMask, UaEncoder encoder) {
        encoder.writeInt32(null, browseResultMask.getValue());
    }

    public static BrowseResultMask decode(UaDecoder decoder) {
        int value = decoder.readInt32(null);
        return (BrowseResultMask)VALUES.getOrDefault((Object)value, null);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BrowseResultMask e : BrowseResultMask.values()) {
            builder.put((Object)e.getValue(), (Object)e);
        }
        VALUES = builder.build();
    }
}

