/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.builtin;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.EncodingLimits;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.DataTypeEncoding;
import org.eclipse.milo.opcua.stack.core.types.DataTypeManager;
import org.eclipse.milo.opcua.stack.core.types.OpcUaDataTypeManager;
import org.eclipse.milo.opcua.stack.core.types.OpcUaDefaultBinaryEncoding;
import org.eclipse.milo.opcua.stack.core.types.OpcUaDefaultXmlEncoding;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.XmlElement;
import org.eclipse.milo.opcua.stack.core.util.Lazy;

public final class ExtensionObject {
    private final Lazy<Object> decoded = new Lazy();
    private final BodyType bodyType;
    private final Object body;
    private final NodeId encodingId;

    public ExtensionObject(@Nonnull ByteString body, @Nonnull NodeId encodingId) {
        this((Object)body, encodingId);
    }

    public ExtensionObject(@Nonnull XmlElement body, @Nonnull NodeId encodingId) {
        this((Object)body, encodingId);
    }

    private ExtensionObject(@Nonnull Object body, @Nonnull NodeId encodingId) {
        this.body = body;
        this.encodingId = encodingId;
        if (body instanceof ByteString) {
            this.bodyType = BodyType.ByteString;
        } else if (body instanceof XmlElement) {
            this.bodyType = BodyType.XmlElement;
        } else {
            throw new IllegalArgumentException("body: " + body);
        }
    }

    public Object getBody() {
        return this.body;
    }

    public BodyType getBodyType() {
        return this.bodyType;
    }

    public NodeId getEncodingId() {
        return this.encodingId;
    }

    public boolean isNull() {
        switch (this.bodyType) {
            case ByteString: {
                return ((ByteString)this.body).isNull();
            }
            case XmlElement: {
                return ((XmlElement)this.body).isNull();
            }
        }
        throw new IllegalStateException("BodyType: " + (Object)((Object)this.bodyType));
    }

    @Deprecated
    public Object decode() throws UaSerializationException {
        SerializationContext context = ExtensionObject.newDefaultSerializationContext();
        return this.decode(context);
    }

    @Deprecated
    @Nullable
    public Object decodeOrNull() {
        try {
            return this.decode();
        }
        catch (UaSerializationException e) {
            return null;
        }
    }

    public Object decode(SerializationContext context) throws UaSerializationException {
        switch (this.bodyType) {
            case ByteString: {
                return this.decode(context, OpcUaDefaultBinaryEncoding.getInstance());
            }
            case XmlElement: {
                return this.decode(context, OpcUaDefaultXmlEncoding.getInstance());
            }
        }
        throw new IllegalStateException("BodyType: " + (Object)((Object)this.bodyType));
    }

    public Object decode(SerializationContext context, DataTypeEncoding encoding) throws UaSerializationException {
        return this.decoded.getOrCompute(() -> encoding.decode(context, this.body, this.encodingId));
    }

    @Nullable
    public Object decodeOrNull(SerializationContext context) {
        try {
            return this.decode(context);
        }
        catch (UaSerializationException e) {
            return null;
        }
    }

    public ExtensionObject transcode(SerializationContext context, NodeId newEncodingId, DataTypeEncoding newEncoding) {
        if (this.encodingId.equals(newEncodingId)) {
            return this;
        }
        Object struct = this.decodeOrNull(context);
        if (struct != null) {
            Object encoded = newEncoding.encode(context, struct, newEncodingId);
            return new ExtensionObject(encoded, newEncodingId);
        }
        return this;
    }

    public static ExtensionObject encode(SerializationContext context, UaStructure struct) throws UaSerializationException {
        NodeId encodingId = struct.getBinaryEncodingId();
        return ExtensionObject.encodeDefaultBinary(context, struct, encodingId);
    }

    public static ExtensionObject encodeDefaultBinary(SerializationContext context, Object object, NodeId encodingId) throws UaSerializationException {
        return ExtensionObject.encode(context, object, encodingId, OpcUaDefaultBinaryEncoding.getInstance());
    }

    public static ExtensionObject encodeDefaultXml(SerializationContext context, Object object, NodeId encodingId) throws UaSerializationException {
        return ExtensionObject.encode(context, object, encodingId, OpcUaDefaultXmlEncoding.getInstance());
    }

    @Deprecated
    public static ExtensionObject encode(Object object, NodeId encodingId, DataTypeEncoding encoding) throws UaSerializationException {
        SerializationContext context = ExtensionObject.newDefaultSerializationContext();
        return ExtensionObject.encode(context, object, encodingId, encoding);
    }

    public static ExtensionObject encode(SerializationContext context, Object object, NodeId encodingId, DataTypeEncoding encoding) throws UaSerializationException {
        Object body = encoding.encode(context, object, encodingId);
        return new ExtensionObject(body, encodingId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtensionObject that = (ExtensionObject)o;
        return Objects.equal((Object)this.body, (Object)that.body) && Objects.equal((Object)this.encodingId, (Object)that.encodingId);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.body, this.encodingId});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("encoded", this.body).add("encodingId", (Object)this.encodingId).toString();
    }

    private static SerializationContext newDefaultSerializationContext() {
        return new SerializationContext(){
            private final NamespaceTable namespaceTable = new NamespaceTable();

            @Override
            public EncodingLimits getEncodingLimits() {
                return EncodingLimits.DEFAULT;
            }

            @Override
            public NamespaceTable getNamespaceTable() {
                return this.namespaceTable;
            }

            @Override
            public DataTypeManager getDataTypeManager() {
                return OpcUaDataTypeManager.getInstance();
            }
        };
    }

    public static enum BodyType {
        ByteString,
        XmlElement;

    }
}

