/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core;

import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import org.eclipse.milo.opcua.stack.core.util.ManifestUtil;
import org.slf4j.LoggerFactory;

public final class Stack {
    public static final String VERSION = ManifestUtil.read("X-Stack-Version").orElse("dev");
    public static final String TCP_UASC_UABINARY_TRANSPORT_URI = "http://opcfoundation.org/UA-Profile/Transport/uatcp-uasc-uabinary";
    public static final String HTTPS_UABINARY_TRANSPORT_URI = "http://opcfoundation.org/UA-Profile/Transport/https-uabinary";
    public static final String HTTPS_UAXML_TRANSPORT_URI = "http://opcfoundation.org/UA-Profile/Transport/https-uasoapxml";
    public static final String HTTPS_UAJSON_TRANSPORT_URI = "http://opcfoundation.org/UA-Profile/Transport/https-uajson";
    public static final String WSS_UASC_UABINARY_TRANSPORT_URI = "http://opcfoundation.org/UA-Profile/Transport/wss-uasc-uabinary";
    public static final String WSS_UAJSON_TRANSPORT_URI = "http://opcfoundation.org/UA-Profile/Transport/wss-uajson";
    public static final String WSS_PROTOCOL_BINARY = "opcua+uacp";
    public static final String WSS_PROTOCOL_JSON = "opcua+uajson";
    public static final int DEFAULT_TCP_PORT = 12685;
    public static final int DEFAULT_HTTP_PORT = 8080;
    public static final int DEFAULT_HTTPS_PORT = 8443;
    private static NioEventLoopGroup EVENT_LOOP;
    private static ExecutorService EXECUTOR_SERVICE;
    private static ScheduledExecutorService SCHEDULED_EXECUTOR_SERVICE;
    private static HashedWheelTimer WHEEL_TIMER;
    private static ClassLoader CUSTOM_CLASS_LOADER;

    public static synchronized NioEventLoopGroup sharedEventLoop() {
        if (EVENT_LOOP == null) {
            ThreadFactory threadFactory = new ThreadFactory(){
                private final AtomicLong threadNumber = new AtomicLong(0L);

                @Override
                public Thread newThread(@Nonnull Runnable r) {
                    Thread thread = new Thread(r, "milo-netty-event-loop-" + this.threadNumber.getAndIncrement());
                    thread.setDaemon(true);
                    return thread;
                }
            };
            EVENT_LOOP = new NioEventLoopGroup(0, threadFactory);
        }
        return EVENT_LOOP;
    }

    public static synchronized ExecutorService sharedExecutor() {
        if (EXECUTOR_SERVICE == null) {
            ThreadFactory threadFactory = new ThreadFactory(){
                private final AtomicLong threadNumber = new AtomicLong(0L);

                @Override
                public Thread newThread(@Nonnull Runnable r) {
                    Thread thread = new Thread(r, "milo-shared-thread-pool-" + this.threadNumber.getAndIncrement());
                    thread.setDaemon(true);
                    thread.setUncaughtExceptionHandler((t, e) -> LoggerFactory.getLogger(Stack.class).warn("Uncaught Exception on shared stack ExecutorService thread!", e));
                    return thread;
                }
            };
            EXECUTOR_SERVICE = Executors.newCachedThreadPool(threadFactory);
        }
        return EXECUTOR_SERVICE;
    }

    public static synchronized ScheduledExecutorService sharedScheduledExecutor() {
        if (SCHEDULED_EXECUTOR_SERVICE == null) {
            ThreadFactory threadFactory = new ThreadFactory(){
                private final AtomicLong threadNumber = new AtomicLong(0L);

                @Override
                public Thread newThread(@Nonnull Runnable r) {
                    Thread thread = new Thread(r, "milo-shared-scheduled-executor-" + this.threadNumber.getAndIncrement());
                    thread.setDaemon(true);
                    thread.setUncaughtExceptionHandler((t, e) -> LoggerFactory.getLogger(Stack.class).warn("Uncaught Exception on shared stack ScheduledExecutorService thread!", e));
                    return thread;
                }
            };
            ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), threadFactory);
            executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            SCHEDULED_EXECUTOR_SERVICE = executor;
        }
        return SCHEDULED_EXECUTOR_SERVICE;
    }

    public static synchronized HashedWheelTimer sharedWheelTimer() {
        if (WHEEL_TIMER == null) {
            ThreadFactory threadFactory = r -> {
                Thread thread = new Thread(r, "milo-netty-wheel-timer");
                thread.setDaemon(true);
                return thread;
            };
            WHEEL_TIMER = new HashedWheelTimer(threadFactory);
        }
        return WHEEL_TIMER;
    }

    public static synchronized Optional<ClassLoader> getCustomClassLoader() {
        return Optional.ofNullable(CUSTOM_CLASS_LOADER);
    }

    public static synchronized void setCustomClassLoader(ClassLoader customClassLoader) {
        CUSTOM_CLASS_LOADER = customClassLoader;
    }

    public static synchronized void releaseSharedResources() {
        Stack.releaseSharedResources(5L, TimeUnit.SECONDS);
    }

    public static synchronized void releaseSharedResources(long timeout, TimeUnit unit) {
        if (EVENT_LOOP != null) {
            try {
                EVENT_LOOP.shutdownGracefully().await(timeout, unit);
            }
            catch (InterruptedException e) {
                LoggerFactory.getLogger(Stack.class).warn("Interrupted awaiting event loop shutdown.", (Throwable)e);
            }
            EVENT_LOOP = null;
        }
        if (SCHEDULED_EXECUTOR_SERVICE != null) {
            SCHEDULED_EXECUTOR_SERVICE.shutdown();
        }
        if (EXECUTOR_SERVICE != null) {
            EXECUTOR_SERVICE.shutdown();
        }
        if (SCHEDULED_EXECUTOR_SERVICE != null) {
            try {
                SCHEDULED_EXECUTOR_SERVICE.awaitTermination(timeout, unit);
            }
            catch (InterruptedException e) {
                LoggerFactory.getLogger(Stack.class).warn("Interrupted awaiting scheduled executor service shutdown.", (Throwable)e);
            }
            SCHEDULED_EXECUTOR_SERVICE = null;
        }
        if (EXECUTOR_SERVICE != null) {
            try {
                EXECUTOR_SERVICE.awaitTermination(timeout, unit);
            }
            catch (InterruptedException e) {
                LoggerFactory.getLogger(Stack.class).warn("Interrupted awaiting executor service shutdown.", (Throwable)e);
            }
            EXECUTOR_SERVICE = null;
        }
        if (WHEEL_TIMER != null) {
            WHEEL_TIMER.stop().forEach(Timeout::cancel);
            WHEEL_TIMER = null;
        }
    }

    public static final class ConnectionLimits {
        public static volatile int HELLO_DEADLINE_MS = 10000;
        public static boolean RATE_LIMIT_ENABLED = true;
        public static int RATE_LIMIT_MAX_ATTEMPTS = 4;
        public static int RATE_LIMIT_WINDOW_MS = 1000;
        public static int RATE_LIMIT_MAX_CONNECTIONS = 10000;
        public static int RATE_LIMIT_MAX_CONNECTIONS_PER_ADDRESS = 100;

        private ConnectionLimits() {
        }
    }
}

