/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.util;

import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.annotations.UaInputArgument;
import org.eclipse.milo.opcua.sdk.server.annotations.UaMethod;
import org.eclipse.milo.opcua.sdk.server.annotations.UaOutputArgument;
import org.eclipse.milo.opcua.sdk.server.api.AccessContext;
import org.eclipse.milo.opcua.sdk.server.api.methods.MethodInvocationHandler;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.Argument;
import org.eclipse.milo.opcua.stack.core.types.structured.CallMethodRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CallMethodResult;
import org.eclipse.milo.opcua.stack.core.util.ConversionUtil;
import org.eclipse.milo.opcua.stack.core.util.TypeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class AnnotationBasedInvocationHandler
implements MethodInvocationHandler {
    private final Logger logger = LoggerFactory.getLogger(AnnotationBasedInvocationHandler.class);
    private final Method annotatedMethod;
    private final OpcUaServer server;
    private final List<Argument> inputArguments;
    private final List<Argument> outputArguments;
    private final Object annotatedObject;

    public AnnotationBasedInvocationHandler(OpcUaServer server, Argument[] inputArguments, Argument[] outputArguments, Object annotatedObject) {
        this(server, Lists.newArrayList((Object[])inputArguments), Lists.newArrayList((Object[])outputArguments), annotatedObject);
    }

    public AnnotationBasedInvocationHandler(OpcUaServer server, List<Argument> inputArguments, List<Argument> outputArguments, Object annotatedObject) {
        this.server = server;
        this.inputArguments = inputArguments;
        this.outputArguments = outputArguments;
        this.annotatedObject = annotatedObject;
        this.annotatedMethod = Arrays.stream(annotatedObject.getClass().getMethods()).filter(m -> m.isAnnotationPresent(UaMethod.class)).findFirst().orElseThrow(() -> new RuntimeException("no @UaMethod annotated annotatedMethod found"));
    }

    public Argument[] getInputArguments() {
        return (Argument[])ConversionUtil.a(this.inputArguments, Argument.class);
    }

    public Argument[] getOutputArguments() {
        return (Argument[])ConversionUtil.a(this.outputArguments, Argument.class);
    }

    @Override
    public CallMethodResult invoke(AccessContext accessContext, CallMethodRequest request) {
        NodeId objectId = request.getObjectId();
        List inputVariants = ConversionUtil.l((Object[])request.getInputArguments());
        if (inputVariants.size() != this.inputArguments.size()) {
            return new CallMethodResult(new StatusCode(2155216896L), new StatusCode[0], new DiagnosticInfo[0], new Variant[0]);
        }
        CompletableFuture future = new CompletableFuture();
        Object[] inputs = new Object[inputVariants.size()];
        StatusCode[] inputArgumentResults = new StatusCode[inputVariants.size()];
        for (int i = 0; i < inputVariants.size(); ++i) {
            Argument argument = this.inputArguments.get(i);
            Variant variant = (Variant)inputVariants.get(i);
            boolean dataTypeMatch = variant.getDataType().map(type -> type.equals((Object)argument.getDataType())).orElse(false);
            inputArgumentResults[i] = !dataTypeMatch ? new StatusCode(2155085824L) : StatusCode.GOOD;
            inputs[i] = variant.getValue();
        }
        int outputCount = this.outputArguments.size();
        CountDownLatch latch = new CountDownLatch(outputCount);
        Object[] outputs = new Object[outputCount];
        for (int i = 0; i < outputCount; ++i) {
            outputs[i] = new OutImpl(latch);
        }
        new Thread(() -> {
            try {
                Object[] parameters = new Object[1 + inputs.length + outputs.length];
                UaNode ownerNode = this.server.getAddressSpaceManager().getManagedNode(objectId).orElseThrow(() -> new Exception("owner node found"));
                InvocationContextImpl context = new InvocationContextImpl(accessContext, ownerNode, future, inputArgumentResults, latch);
                parameters[0] = context;
                System.arraycopy(inputs, 0, parameters, 1, inputs.length);
                System.arraycopy(outputs, 0, parameters, 1 + inputs.length, outputs.length);
                this.annotatedMethod.invoke(this.annotatedObject, parameters);
                latch.await();
                if (!future.isDone()) {
                    Variant[] values = new Variant[outputCount];
                    for (int i = 0; i < outputCount; ++i) {
                        values[i] = new Variant(((OutImpl)outputs[i]).get());
                    }
                    future.complete(new CallMethodResult(StatusCode.GOOD, inputArgumentResults, new DiagnosticInfo[0], values));
                }
            }
            catch (InvocationTargetException e) {
                Throwable targetException = e.getTargetException();
                this.logger.error("Error invoking annotated method: {} on annotated object: {}", new Object[]{this.annotatedMethod, this.annotatedObject, targetException});
                if (targetException instanceof UaException) {
                    StatusCode statusCode = ((UaException)targetException).getStatusCode();
                    future.complete(new CallMethodResult(statusCode, inputArgumentResults, new DiagnosticInfo[0], new Variant[0]));
                } else {
                    future.complete(new CallMethodResult(new StatusCode(0x80020000L), inputArgumentResults, new DiagnosticInfo[0], new Variant[0]));
                }
            }
            catch (Throwable t) {
                this.logger.error("Error invoking annotated method: {} on annotated object: {}", new Object[]{this.annotatedMethod, this.annotatedObject, t});
                future.complete(new CallMethodResult(new StatusCode(0x80020000L), inputArgumentResults, new DiagnosticInfo[0], new Variant[0]));
            }
        }).start();
        try {
            return (CallMethodResult)future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            this.logger.error("Error invoking annotated method: {} on annotated object: {}", new Object[]{this.annotatedMethod, this.annotatedObject, e});
            return new CallMethodResult(new StatusCode(0x80020000L), new StatusCode[0], new DiagnosticInfo[0], new Variant[0]);
        }
    }

    public static AnnotationBasedInvocationHandler fromAnnotatedObject(OpcUaServer server, Object annotatedObject) throws Exception {
        Method annotatedMethod = Arrays.stream(annotatedObject.getClass().getMethods()).filter(m -> m.isAnnotationPresent(UaMethod.class)).findFirst().orElseThrow(() -> new Exception("no @UaMethod annotated annotatedMethod found"));
        Parameter[] parameters = annotatedMethod.getParameters();
        Type[] parameterTypes = annotatedMethod.getGenericParameterTypes();
        assert (parameters.length == parameterTypes.length);
        ArrayList inputArguments = Lists.newArrayList();
        ArrayList outputArguments = Lists.newArrayList();
        for (int i = 0; i < parameters.length; ++i) {
            Type parameterType;
            String description;
            String name;
            Parameter parameter = parameters[i];
            if (parameter.isAnnotationPresent(UaInputArgument.class)) {
                name = parameter.getAnnotation(UaInputArgument.class).name();
                description = parameter.getAnnotation(UaInputArgument.class).description();
                parameterType = (Class)parameterTypes[i];
                int dimensions = 0;
                while (((Class)parameterType).isArray()) {
                    parameterType = ((Class)parameterType).getComponentType();
                    ++dimensions;
                }
                UInteger[] arrayDimensions = dimensions > 0 ? new UInteger[dimensions] : null;
                inputArguments.add(new Argument(name, AnnotationBasedInvocationHandler.getDataType(parameterType), Integer.valueOf(dimensions > 0 ? dimensions : -1), arrayDimensions, LocalizedText.english((String)description)));
            }
            if (!parameter.isAnnotationPresent(UaOutputArgument.class)) continue;
            name = parameter.getAnnotation(UaOutputArgument.class).name();
            description = parameter.getAnnotation(UaOutputArgument.class).description();
            parameterType = (ParameterizedType)parameterTypes[i];
            Class<?> actualType = (Class<?>)parameterType.getActualTypeArguments()[0];
            int dimensions = 0;
            while (actualType.isArray()) {
                actualType = actualType.getComponentType();
                ++dimensions;
            }
            UInteger[] arrayDimensions = dimensions > 0 ? new UInteger[dimensions] : null;
            outputArguments.add(new Argument(name, AnnotationBasedInvocationHandler.getDataType(actualType), Integer.valueOf(dimensions > 0 ? dimensions : -1), arrayDimensions, LocalizedText.english((String)description)));
        }
        return new AnnotationBasedInvocationHandler(server, inputArguments, outputArguments, annotatedObject);
    }

    private static NodeId getDataType(Class<?> clazz) {
        return new NodeId(0, TypeUtil.getBuiltinTypeId(clazz));
    }

    private static class InvocationContextImpl
    implements InvocationContext {
        private final AccessContext accessContext;
        private final UaNode ownerNode;
        private final CompletableFuture<CallMethodResult> future;
        private final StatusCode[] inputArgumentResults;
        private final CountDownLatch latch;

        private InvocationContextImpl(AccessContext accessContext, UaNode ownerNode, CompletableFuture<CallMethodResult> future, StatusCode[] inputArgumentResults, CountDownLatch latch) {
            this.accessContext = accessContext;
            this.ownerNode = ownerNode;
            this.inputArgumentResults = inputArgumentResults;
            this.future = future;
            this.latch = latch;
        }

        @Override
        public Optional<Session> getSession() {
            return this.accessContext.getSession();
        }

        @Override
        public UaNode getOwnerNode() {
            return this.ownerNode;
        }

        @Override
        public void setFailure(UaException failure) {
            StatusCode statusCode = failure.getStatusCode();
            this.future.complete(new CallMethodResult(statusCode, this.inputArgumentResults, new DiagnosticInfo[0], new Variant[0]));
            while (this.latch.getCount() > 0L) {
                this.latch.countDown();
            }
        }
    }

    private static class OutImpl<T>
    implements Out<T> {
        private final AtomicReference<T> value = new AtomicReference();
        private volatile boolean set = false;
        private final CountDownLatch latch;

        public OutImpl(CountDownLatch latch) {
            this.latch = latch;
        }

        @Override
        public synchronized void set(T value) {
            this.value.set(value);
            if (!this.set) {
                this.latch.countDown();
                this.set = true;
            }
        }

        T get() {
            return this.value.get();
        }
    }

    public static interface InvocationContext
    extends AccessContext {
        public UaNode getOwnerNode();

        public void setFailure(UaException var1);
    }

    public static interface Out<T> {
        public void set(T var1);
    }
}

