/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.nodes.variables;

import java.util.Optional;
import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.DataItemNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.PropertyNode;
import org.eclipse.milo.opcua.sdk.server.model.types.variables.ArrayItemType;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNodeContext;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.AxisScaleEnumeration;
import org.eclipse.milo.opcua.stack.core.types.structured.EUInformation;
import org.eclipse.milo.opcua.stack.core.types.structured.Range;

public class ArrayItemNode
extends DataItemNode
implements ArrayItemType {
    public ArrayItemNode(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask) {
        super(context, nodeId, browseName, displayName, description, writeMask, userWriteMask);
    }

    public ArrayItemNode(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, DataValue value, NodeId dataType, Integer valueRank, UInteger[] arrayDimensions, UByte accessLevel, UByte userAccessLevel, double minimumSamplingInterval, boolean historizing) {
        super(context, nodeId, browseName, displayName, description, writeMask, userWriteMask, value, dataType, valueRank, arrayDimensions, accessLevel, userAccessLevel, minimumSamplingInterval, historizing);
    }

    @Override
    public PropertyNode getInstrumentRangeNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ArrayItemType.INSTRUMENT_RANGE);
        return propertyNode.orElse(null);
    }

    @Override
    public Range getInstrumentRange() {
        Optional<Range> propertyValue = this.getProperty(ArrayItemType.INSTRUMENT_RANGE);
        return propertyValue.orElse(null);
    }

    @Override
    public void setInstrumentRange(Range value) {
        this.setProperty(ArrayItemType.INSTRUMENT_RANGE, value);
    }

    @Override
    public PropertyNode getEURangeNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ArrayItemType.E_U_RANGE);
        return propertyNode.orElse(null);
    }

    @Override
    public Range getEURange() {
        Optional<Range> propertyValue = this.getProperty(ArrayItemType.E_U_RANGE);
        return propertyValue.orElse(null);
    }

    @Override
    public void setEURange(Range value) {
        this.setProperty(ArrayItemType.E_U_RANGE, value);
    }

    @Override
    public PropertyNode getEngineeringUnitsNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ArrayItemType.ENGINEERING_UNITS);
        return propertyNode.orElse(null);
    }

    @Override
    public EUInformation getEngineeringUnits() {
        Optional<EUInformation> propertyValue = this.getProperty(ArrayItemType.ENGINEERING_UNITS);
        return propertyValue.orElse(null);
    }

    @Override
    public void setEngineeringUnits(EUInformation value) {
        this.setProperty(ArrayItemType.ENGINEERING_UNITS, value);
    }

    @Override
    public PropertyNode getTitleNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ArrayItemType.TITLE);
        return propertyNode.orElse(null);
    }

    @Override
    public LocalizedText getTitle() {
        Optional<LocalizedText> propertyValue = this.getProperty(ArrayItemType.TITLE);
        return propertyValue.orElse(null);
    }

    @Override
    public void setTitle(LocalizedText value) {
        this.setProperty(ArrayItemType.TITLE, value);
    }

    @Override
    public PropertyNode getAxisScaleTypeNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ArrayItemType.AXIS_SCALE_TYPE);
        return propertyNode.orElse(null);
    }

    @Override
    public AxisScaleEnumeration getAxisScaleType() {
        Optional<AxisScaleEnumeration> propertyValue = this.getProperty(ArrayItemType.AXIS_SCALE_TYPE);
        return propertyValue.orElse(null);
    }

    @Override
    public void setAxisScaleType(AxisScaleEnumeration value) {
        this.setProperty(ArrayItemType.AXIS_SCALE_TYPE, value);
    }
}

