/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.nodes.objects;

import java.util.Optional;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.ConditionNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.PropertyNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.TwoStateVariableNode;
import org.eclipse.milo.opcua.sdk.server.model.types.objects.DialogConditionType;
import org.eclipse.milo.opcua.sdk.server.nodes.UaMethodNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNodeContext;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;

public class DialogConditionNode
extends ConditionNode
implements DialogConditionType {
    public DialogConditionNode(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask) {
        super(context, nodeId, browseName, displayName, description, writeMask, userWriteMask);
    }

    public DialogConditionNode(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, UByte eventNotifier) {
        super(context, nodeId, browseName, displayName, description, writeMask, userWriteMask, eventNotifier);
    }

    @Override
    public PropertyNode getLastResponseNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(DialogConditionType.LAST_RESPONSE);
        return propertyNode.orElse(null);
    }

    @Override
    public Integer getLastResponse() {
        Optional<Integer> propertyValue = this.getProperty(DialogConditionType.LAST_RESPONSE);
        return propertyValue.orElse(null);
    }

    @Override
    public void setLastResponse(Integer value) {
        this.setProperty(DialogConditionType.LAST_RESPONSE, value);
    }

    @Override
    public PropertyNode getCancelResponseNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(DialogConditionType.CANCEL_RESPONSE);
        return propertyNode.orElse(null);
    }

    @Override
    public Integer getCancelResponse() {
        Optional<Integer> propertyValue = this.getProperty(DialogConditionType.CANCEL_RESPONSE);
        return propertyValue.orElse(null);
    }

    @Override
    public void setCancelResponse(Integer value) {
        this.setProperty(DialogConditionType.CANCEL_RESPONSE, value);
    }

    @Override
    public PropertyNode getPromptNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(DialogConditionType.PROMPT);
        return propertyNode.orElse(null);
    }

    @Override
    public LocalizedText getPrompt() {
        Optional<LocalizedText> propertyValue = this.getProperty(DialogConditionType.PROMPT);
        return propertyValue.orElse(null);
    }

    @Override
    public void setPrompt(LocalizedText value) {
        this.setProperty(DialogConditionType.PROMPT, value);
    }

    @Override
    public PropertyNode getOkResponseNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(DialogConditionType.OK_RESPONSE);
        return propertyNode.orElse(null);
    }

    @Override
    public Integer getOkResponse() {
        Optional<Integer> propertyValue = this.getProperty(DialogConditionType.OK_RESPONSE);
        return propertyValue.orElse(null);
    }

    @Override
    public void setOkResponse(Integer value) {
        this.setProperty(DialogConditionType.OK_RESPONSE, value);
    }

    @Override
    public PropertyNode getResponseOptionSetNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(DialogConditionType.RESPONSE_OPTION_SET);
        return propertyNode.orElse(null);
    }

    @Override
    public LocalizedText[] getResponseOptionSet() {
        Optional<LocalizedText[]> propertyValue = this.getProperty(DialogConditionType.RESPONSE_OPTION_SET);
        return propertyValue.orElse(null);
    }

    @Override
    public void setResponseOptionSet(LocalizedText[] value) {
        this.setProperty(DialogConditionType.RESPONSE_OPTION_SET, value);
    }

    @Override
    public PropertyNode getDefaultResponseNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(DialogConditionType.DEFAULT_RESPONSE);
        return propertyNode.orElse(null);
    }

    @Override
    public Integer getDefaultResponse() {
        Optional<Integer> propertyValue = this.getProperty(DialogConditionType.DEFAULT_RESPONSE);
        return propertyValue.orElse(null);
    }

    @Override
    public void setDefaultResponse(Integer value) {
        this.setProperty(DialogConditionType.DEFAULT_RESPONSE, value);
    }

    @Override
    public UaMethodNode getRespondMethodNode() {
        Optional<UaNode> methodNode = this.findNode("http://opcfoundation.org/UA/", "Respond", node -> node instanceof UaMethodNode, Reference.HAS_COMPONENT_PREDICATE);
        return methodNode.orElse(null);
    }

    @Override
    public TwoStateVariableNode getEnabledStateNode() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "EnabledState");
        return component.orElse(null);
    }

    @Override
    public LocalizedText getEnabledState() {
        Optional<VariableNode> component = this.getVariableComponent("EnabledState");
        return component.map(node -> (LocalizedText)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public void setEnabledState(LocalizedText value) {
        this.getVariableComponent("EnabledState").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }

    @Override
    public TwoStateVariableNode getDialogStateNode() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "DialogState");
        return component.orElse(null);
    }

    @Override
    public LocalizedText getDialogState() {
        Optional<VariableNode> component = this.getVariableComponent("DialogState");
        return component.map(node -> (LocalizedText)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public void setDialogState(LocalizedText value) {
        this.getVariableComponent("DialogState").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }
}

