/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.events.conversions;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.BuiltinDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.ULong;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;

final class FloatConversions {
    private FloatConversions() {
    }

    @Nonnull
    static Boolean floatToBoolean(@Nonnull Float f) {
        return f.floatValue() != 0.0f;
    }

    @Nullable
    static UByte floatToByte(@Nonnull Float f) {
        long rounded = Math.round(f.floatValue());
        if (rounded >= 0L && rounded <= 255L) {
            return Unsigned.ubyte((long)rounded);
        }
        return null;
    }

    @Nonnull
    static Double floatToDouble(@Nonnull Float f) {
        return f.doubleValue();
    }

    @Nullable
    static Short floatToInt16(@Nonnull Float f) {
        long rounded = Math.round(f.floatValue());
        if (rounded >= -32768L && rounded <= 32767L) {
            return (short)rounded;
        }
        return null;
    }

    @Nonnull
    static Integer floatToInt32(@Nonnull Float f) {
        return Math.round(f.floatValue());
    }

    @Nonnull
    static Long floatToInt64(@Nonnull Float f) {
        return Math.round(f.floatValue());
    }

    @Nullable
    static Byte floatToSByte(@Nonnull Float f) {
        long rounded = Math.round(f.floatValue());
        if (rounded >= -128L && rounded <= 127L) {
            return (byte)rounded;
        }
        return null;
    }

    @Nonnull
    static String floatToString(@Nonnull Float f) {
        return f.toString();
    }

    @Nullable
    static UShort floatToUInt16(@Nonnull Float f) {
        long rounded = Math.round(f.floatValue());
        if (rounded >= 0L && rounded <= 65535L) {
            return Unsigned.ushort((int)((int)rounded));
        }
        return null;
    }

    @Nullable
    static UInteger floatToUInt32(@Nonnull Float f) {
        int rounded = Math.round(f.floatValue());
        if (rounded >= 0) {
            return Unsigned.uint((int)rounded);
        }
        return null;
    }

    @Nullable
    static ULong floatToUInt64(@Nonnull Float f) {
        long rounded = Math.round(f.floatValue());
        if (rounded >= 0L) {
            return Unsigned.ulong((long)rounded);
        }
        return null;
    }

    @Nullable
    static Object convert(@Nullable Object o, BuiltinDataType targetType, boolean implicit) {
        if (o instanceof Float) {
            Float f = (Float)o;
            return implicit ? FloatConversions.implicitConversion(f, targetType) : FloatConversions.explicitConversion(f, targetType);
        }
        return null;
    }

    @Nullable
    static Object explicitConversion(@Nonnull Float f, BuiltinDataType targetType) {
        switch (targetType) {
            case Boolean: {
                return FloatConversions.floatToBoolean(f);
            }
            case Byte: {
                return FloatConversions.floatToByte(f);
            }
            case Int16: {
                return FloatConversions.floatToInt16(f);
            }
            case Int32: {
                return FloatConversions.floatToInt32(f);
            }
            case Int64: {
                return FloatConversions.floatToInt64(f);
            }
            case SByte: {
                return FloatConversions.floatToSByte(f);
            }
            case String: {
                return FloatConversions.floatToString(f);
            }
            case UInt16: {
                return FloatConversions.floatToUInt16(f);
            }
            case UInt32: {
                return FloatConversions.floatToUInt32(f);
            }
            case UInt64: {
                return FloatConversions.floatToUInt64(f);
            }
        }
        return FloatConversions.implicitConversion(f, targetType);
    }

    @Nullable
    static Object implicitConversion(@Nonnull Float f, BuiltinDataType targetType) {
        switch (targetType) {
            case Double: {
                return FloatConversions.floatToDouble(f);
            }
        }
        return null;
    }
}

