/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.nodes.objects;

import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.FiniteStateMachineNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.StateNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.TransitionNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.PropertyNode;
import org.eclipse.milo.opcua.sdk.client.model.types.objects.ShelvedStateMachineType;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;

public class ShelvedStateMachineNode
extends FiniteStateMachineNode
implements ShelvedStateMachineType {
    public ShelvedStateMachineNode(OpcUaClient client, NodeId nodeId) {
        super(client, nodeId);
    }

    public CompletableFuture<PropertyNode> getUnshelveTimeNode() {
        return this.getPropertyNode(ShelvedStateMachineType.UNSHELVE_TIME);
    }

    @Override
    public CompletableFuture<Double> getUnshelveTime() {
        return this.getProperty(ShelvedStateMachineType.UNSHELVE_TIME);
    }

    @Override
    public CompletableFuture<StatusCode> setUnshelveTime(Double value) {
        return this.setProperty(ShelvedStateMachineType.UNSHELVE_TIME, value);
    }

    public CompletableFuture<StateNode> getUnshelvedNode() {
        return this.getObjectComponent("http://opcfoundation.org/UA/", "Unshelved").thenApply(StateNode.class::cast);
    }

    public CompletableFuture<StateNode> getTimedShelvedNode() {
        return this.getObjectComponent("http://opcfoundation.org/UA/", "TimedShelved").thenApply(StateNode.class::cast);
    }

    public CompletableFuture<StateNode> getOneShotShelvedNode() {
        return this.getObjectComponent("http://opcfoundation.org/UA/", "OneShotShelved").thenApply(StateNode.class::cast);
    }

    public CompletableFuture<TransitionNode> getUnshelvedToTimedShelvedNode() {
        return this.getObjectComponent("http://opcfoundation.org/UA/", "UnshelvedToTimedShelved").thenApply(TransitionNode.class::cast);
    }

    public CompletableFuture<TransitionNode> getUnshelvedToOneShotShelvedNode() {
        return this.getObjectComponent("http://opcfoundation.org/UA/", "UnshelvedToOneShotShelved").thenApply(TransitionNode.class::cast);
    }

    public CompletableFuture<TransitionNode> getTimedShelvedToUnshelvedNode() {
        return this.getObjectComponent("http://opcfoundation.org/UA/", "TimedShelvedToUnshelved").thenApply(TransitionNode.class::cast);
    }

    public CompletableFuture<TransitionNode> getTimedShelvedToOneShotShelvedNode() {
        return this.getObjectComponent("http://opcfoundation.org/UA/", "TimedShelvedToOneShotShelved").thenApply(TransitionNode.class::cast);
    }

    public CompletableFuture<TransitionNode> getOneShotShelvedToUnshelvedNode() {
        return this.getObjectComponent("http://opcfoundation.org/UA/", "OneShotShelvedToUnshelved").thenApply(TransitionNode.class::cast);
    }

    public CompletableFuture<TransitionNode> getOneShotShelvedToTimedShelvedNode() {
        return this.getObjectComponent("http://opcfoundation.org/UA/", "OneShotShelvedToTimedShelved").thenApply(TransitionNode.class::cast);
    }
}

