/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.nodes.factories;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.server.ObjectTypeManager;
import org.eclipse.milo.opcua.sdk.server.VariableTypeManager;
import org.eclipse.milo.opcua.sdk.server.api.AddressSpaceManager;
import org.eclipse.milo.opcua.sdk.server.api.nodes.MethodNode;
import org.eclipse.milo.opcua.sdk.server.api.nodes.Node;
import org.eclipse.milo.opcua.sdk.server.api.nodes.ObjectNode;
import org.eclipse.milo.opcua.sdk.server.api.nodes.ObjectTypeNode;
import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaMethodNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNodeContext;
import org.eclipse.milo.opcua.sdk.server.nodes.UaObjectNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaVariableNode;
import org.eclipse.milo.opcua.sdk.server.nodes.factories.BrowsePath;
import org.eclipse.milo.opcua.sdk.server.nodes.factories.InstanceDeclarationHierarchy;
import org.eclipse.milo.opcua.sdk.server.nodes.factories.NodeTable;
import org.eclipse.milo.opcua.sdk.server.nodes.factories.ReferenceTable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.util.Tree;

public class NodeFactory {
    private final UaNodeContext context;
    private final ObjectTypeManager objectTypeManager;
    private final VariableTypeManager variableTypeManager;

    public NodeFactory(UaNodeContext context) {
        this(context, context.getServer().getObjectTypeManager(), context.getServer().getVariableTypeManager());
    }

    public NodeFactory(UaNodeContext context, ObjectTypeManager objectTypeManager, VariableTypeManager variableTypeManager) {
        this.context = context;
        this.objectTypeManager = objectTypeManager;
        this.variableTypeManager = variableTypeManager;
    }

    public UaNode createNode(NodeId rootNodeId, NodeId typeDefinitionId, boolean includeOptionalNodes) throws UaException {
        Tree<UaNode> nodeTree = this.createNodeTree(rootNodeId, typeDefinitionId, includeOptionalNodes);
        return (UaNode)nodeTree.getValue();
    }

    public UaNode createNode(NodeId rootNodeId, NodeId typeDefinitionId, boolean includeOptionalNodes, InstanceListener instanceListener) throws UaException {
        Tree<UaNode> nodeTree = this.createNodeTree(rootNodeId, typeDefinitionId, includeOptionalNodes);
        this.notifyInstanceListener(nodeTree, instanceListener);
        return (UaNode)nodeTree.getValue();
    }

    public Tree<UaNode> createNodeTree(NodeId rootNodeId, NodeId typeDefinitionId, boolean includeOptionalNodes) throws UaException {
        AddressSpaceManager addressSpaceManager = this.context.getServer().getAddressSpaceManager();
        if (!addressSpaceManager.getManagedNode(typeDefinitionId).isPresent()) {
            throw new UaException(2150891520L, "unknown type definition: " + typeDefinitionId);
        }
        NamespaceTable namespaceTable = this.context.getServer().getNamespaceTable();
        InstanceDeclarationHierarchy idh = InstanceDeclarationHierarchy.create(addressSpaceManager, namespaceTable, typeDefinitionId, includeOptionalNodes);
        NodeTable nodeTable = idh.getNodeTable();
        ReferenceTable referenceTable = idh.getReferenceTable();
        HashMap<BrowsePath, UaNode> nodes = new HashMap<BrowsePath, UaNode>();
        for (Map.Entry<BrowsePath, NodeId> entry : nodeTable.nodes.entrySet()) {
            UaNode instance;
            UaNode typeDefinitionNode;
            ExpandedNodeId instanceTypeDefinitionId;
            Node declaration;
            BrowsePath browsePath2 = entry.getKey();
            NodeId nodeId = entry.getValue();
            UaNode node2 = addressSpaceManager.getManagedNode(nodeId).orElse(null);
            if (browsePath2.parent == null) {
                UaNode instance2;
                if (node2 instanceof ObjectTypeNode) {
                    instance2 = this.instanceFromTypeDefinition(rootNodeId, (ObjectTypeNode)((Object)node2));
                    nodes.put(browsePath2, instance2);
                    continue;
                }
                if (node2 instanceof VariableTypeNode) {
                    instance2 = this.instanceFromTypeDefinition(rootNodeId, (VariableTypeNode)((Object)node2));
                    nodes.put(browsePath2, instance2);
                    continue;
                }
                throw new UaException(0x80020000L);
            }
            NodeId instanceNodeId = this.instanceNodeId(rootNodeId, browsePath2);
            if (node2 instanceof MethodNode) {
                declaration = (MethodNode)((Object)node2);
                UaMethodNode instance3 = new UaMethodNode(this.context, instanceNodeId, declaration.getBrowseName(), declaration.getDisplayName(), declaration.getDescription(), declaration.getWriteMask(), declaration.getUserWriteMask(), declaration.isExecutable(), declaration.isUserExecutable());
                nodes.put(browsePath2, instance3);
                continue;
            }
            if (node2 instanceof ObjectNode) {
                declaration = (ObjectNode)((Object)node2);
                instanceTypeDefinitionId = NodeFactory.getTypeDefinition(referenceTable, browsePath2);
                typeDefinitionNode = addressSpaceManager.getManagedNode(instanceTypeDefinitionId).orElse(null);
                if (typeDefinitionNode instanceof ObjectTypeNode) {
                    instance = this.instanceFromTypeDefinition(instanceNodeId, (ObjectTypeNode)((Object)typeDefinitionNode));
                    instance.setBrowseName(declaration.getBrowseName());
                    instance.setDisplayName(declaration.getDisplayName());
                    instance.setDescription(declaration.getDescription());
                    instance.setWriteMask(declaration.getWriteMask());
                    instance.setUserWriteMask(declaration.getUserWriteMask());
                    ((UaObjectNode)instance).setEventNotifier(declaration.getEventNotifier());
                    nodes.put(browsePath2, instance);
                    continue;
                }
                throw new UaException(0x80020000L, "expected type definition for " + instanceTypeDefinitionId);
            }
            if (node2 instanceof VariableNode) {
                declaration = (VariableNode)((Object)node2);
                instanceTypeDefinitionId = NodeFactory.getTypeDefinition(referenceTable, browsePath2);
                typeDefinitionNode = addressSpaceManager.getManagedNode(instanceTypeDefinitionId).orElse(null);
                if (typeDefinitionNode instanceof VariableTypeNode) {
                    instance = this.instanceFromTypeDefinition(instanceNodeId, (VariableTypeNode)((Object)typeDefinitionNode));
                    instance.setBrowseName(declaration.getBrowseName());
                    instance.setDisplayName(declaration.getDisplayName());
                    instance.setDescription(declaration.getDescription());
                    instance.setWriteMask(declaration.getWriteMask());
                    instance.setUserWriteMask(declaration.getUserWriteMask());
                    ((UaVariableNode)instance).setValue(declaration.getValue());
                    ((UaVariableNode)instance).setDataType(declaration.getDataType());
                    ((UaVariableNode)instance).setValueRank(declaration.getValueRank());
                    ((UaVariableNode)instance).setArrayDimensions(declaration.getArrayDimensions());
                    ((UaVariableNode)instance).setAccessLevel(declaration.getAccessLevel());
                    ((UaVariableNode)instance).setUserAccessLevel(declaration.getUserAccessLevel());
                    nodes.put(browsePath2, instance);
                    continue;
                }
                throw new UaException(0x80020000L, "expected type definition for " + instanceTypeDefinitionId);
            }
            throw new UaException(0x80020000L, "not an instance declaration: " + node2);
        }
        nodes.forEach((browsePath, node) -> {
            List<ReferenceTable.RefRow> references = referenceTable.getReferences((BrowsePath)browsePath);
            references.forEach(t -> {
                NodeId referenceTypeId = t.nodeId;
                ReferenceTable.RefTarget target = t.target;
                if (!Identifiers.HasModellingRule.equals((Object)referenceTypeId)) {
                    if (target.targetNodeId != null) {
                        node.addReference(new Reference(node.getNodeId(), referenceTypeId, target.targetNodeId, true));
                    } else {
                        BrowsePath targetPath = target.targetPath;
                        UaNode targetNode = (UaNode)nodes.get(targetPath);
                        if (targetNode != null) {
                            node.addReference(new Reference(node.getNodeId(), referenceTypeId, targetNode.getNodeId().expanded(), true));
                        }
                    }
                }
            });
            this.context.getNodeManager().addNode((UaNode)node);
        });
        return nodeTable.getBrowsePathTree().map(nodes::get);
    }

    protected void notifyInstanceListener(Tree<UaNode> nodeTree, InstanceListener instanceListener) {
        nodeTree.traverse((node, parentNode) -> {
            if (parentNode instanceof UaObjectNode && node instanceof UaMethodNode) {
                UaMethodNode methodNode = (UaMethodNode)node;
                instanceListener.onMethodAdded((UaObjectNode)parentNode, methodNode);
            } else if (parentNode instanceof UaObjectNode && node instanceof UaObjectNode) {
                UaObjectNode objectNode = (UaObjectNode)node;
                ObjectTypeNode objectTypeNode = objectNode.getTypeDefinitionNode();
                instanceListener.onObjectAdded((UaObjectNode)parentNode, objectNode, objectTypeNode.getNodeId());
            } else if (node instanceof UaVariableNode) {
                UaVariableNode variableNode = (UaVariableNode)node;
                VariableTypeNode variableTypeNode = variableNode.getTypeDefinitionNode();
                instanceListener.onVariableAdded((UaNode)parentNode, variableNode, variableTypeNode.getNodeId());
            }
        });
    }

    protected NodeId instanceNodeId(NodeId rootNodeId, BrowsePath browsePath) {
        Object rootIdentifier = rootNodeId.getIdentifier();
        String instanceIdentifier = String.format("%s%s", rootIdentifier, browsePath.join());
        return new NodeId(rootNodeId.getNamespaceIndex(), instanceIdentifier);
    }

    protected UaObjectNode instanceFromTypeDefinition(NodeId nodeId, ObjectTypeNode typeDefinitionNode) {
        NodeId typeDefinitionId = typeDefinitionNode.getNodeId();
        ObjectTypeManager.ObjectNodeConstructor ctor = this.objectTypeManager.getNodeFactory(typeDefinitionId).orElse(UaObjectNode::new);
        return ctor.apply(this.context, nodeId, typeDefinitionNode.getBrowseName(), typeDefinitionNode.getDisplayName(), typeDefinitionNode.getDescription(), typeDefinitionNode.getWriteMask(), typeDefinitionNode.getUserWriteMask());
    }

    protected UaVariableNode instanceFromTypeDefinition(NodeId nodeId, VariableTypeNode typeDefinitionNode) {
        NodeId typeDefinitionId = typeDefinitionNode.getNodeId();
        VariableTypeManager.VariableNodeConstructor ctor = this.variableTypeManager.getNodeFactory(typeDefinitionId).orElse(UaVariableNode::new);
        return ctor.apply(this.context, nodeId, typeDefinitionNode.getBrowseName(), typeDefinitionNode.getDisplayName(), typeDefinitionNode.getDescription(), typeDefinitionNode.getWriteMask(), typeDefinitionNode.getUserWriteMask());
    }

    private static ExpandedNodeId getTypeDefinition(ReferenceTable referenceTable, BrowsePath browsePath) {
        return referenceTable.getReferences(browsePath).stream().filter(t -> t.nodeId.equals((Object)Identifiers.HasTypeDefinition)).map(t -> t.target.targetNodeId).findFirst().orElse(ExpandedNodeId.NULL_VALUE);
    }

    static interface InstanceListener {
        default public void onMethodAdded(@Nullable UaObjectNode parent, UaMethodNode instance) {
        }

        default public void onObjectAdded(@Nullable UaObjectNode parent, UaObjectNode instance, NodeId typeDefinitionId) {
        }

        default public void onVariableAdded(@Nullable UaNode parent, UaVariableNode instance, NodeId typeDefinitionId) {
        }
    }
}

