/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.nodes.objects;

import java.util.Optional;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.server.api.nodes.ObjectNode;
import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.BaseObjectNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.FiniteStateMachineNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.StateNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.TransitionNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.FiniteStateVariableNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.FiniteTransitionVariableNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.ProgramDiagnosticNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.PropertyNode;
import org.eclipse.milo.opcua.sdk.server.model.types.objects.ProgramStateMachineType;
import org.eclipse.milo.opcua.sdk.server.nodes.UaMethodNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNodeContext;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.ProgramDiagnosticDataType;

public class ProgramStateMachineNode
extends FiniteStateMachineNode
implements ProgramStateMachineType {
    public ProgramStateMachineNode(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask) {
        super(context, nodeId, browseName, displayName, description, writeMask, userWriteMask);
    }

    public ProgramStateMachineNode(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, UByte eventNotifier) {
        super(context, nodeId, browseName, displayName, description, writeMask, userWriteMask, eventNotifier);
    }

    @Override
    public PropertyNode getAutoDeleteNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ProgramStateMachineType.AUTO_DELETE);
        return propertyNode.orElse(null);
    }

    @Override
    public Boolean getAutoDelete() {
        Optional<Boolean> propertyValue = this.getProperty(ProgramStateMachineType.AUTO_DELETE);
        return propertyValue.orElse(null);
    }

    @Override
    public void setAutoDelete(Boolean value) {
        this.setProperty(ProgramStateMachineType.AUTO_DELETE, value);
    }

    @Override
    public PropertyNode getMaxRecycleCountNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ProgramStateMachineType.MAX_RECYCLE_COUNT);
        return propertyNode.orElse(null);
    }

    @Override
    public UInteger getMaxRecycleCount() {
        Optional<UInteger> propertyValue = this.getProperty(ProgramStateMachineType.MAX_RECYCLE_COUNT);
        return propertyValue.orElse(null);
    }

    @Override
    public void setMaxRecycleCount(UInteger value) {
        this.setProperty(ProgramStateMachineType.MAX_RECYCLE_COUNT, value);
    }

    @Override
    public PropertyNode getInstanceCountNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ProgramStateMachineType.INSTANCE_COUNT);
        return propertyNode.orElse(null);
    }

    @Override
    public UInteger getInstanceCount() {
        Optional<UInteger> propertyValue = this.getProperty(ProgramStateMachineType.INSTANCE_COUNT);
        return propertyValue.orElse(null);
    }

    @Override
    public void setInstanceCount(UInteger value) {
        this.setProperty(ProgramStateMachineType.INSTANCE_COUNT, value);
    }

    @Override
    public PropertyNode getDeletableNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ProgramStateMachineType.DELETABLE);
        return propertyNode.orElse(null);
    }

    @Override
    public Boolean getDeletable() {
        Optional<Boolean> propertyValue = this.getProperty(ProgramStateMachineType.DELETABLE);
        return propertyValue.orElse(null);
    }

    @Override
    public void setDeletable(Boolean value) {
        this.setProperty(ProgramStateMachineType.DELETABLE, value);
    }

    @Override
    public PropertyNode getRecycleCountNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ProgramStateMachineType.RECYCLE_COUNT);
        return propertyNode.orElse(null);
    }

    @Override
    public Integer getRecycleCount() {
        Optional<Integer> propertyValue = this.getProperty(ProgramStateMachineType.RECYCLE_COUNT);
        return propertyValue.orElse(null);
    }

    @Override
    public void setRecycleCount(Integer value) {
        this.setProperty(ProgramStateMachineType.RECYCLE_COUNT, value);
    }

    @Override
    public PropertyNode getMaxInstanceCountNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ProgramStateMachineType.MAX_INSTANCE_COUNT);
        return propertyNode.orElse(null);
    }

    @Override
    public UInteger getMaxInstanceCount() {
        Optional<UInteger> propertyValue = this.getProperty(ProgramStateMachineType.MAX_INSTANCE_COUNT);
        return propertyValue.orElse(null);
    }

    @Override
    public void setMaxInstanceCount(UInteger value) {
        this.setProperty(ProgramStateMachineType.MAX_INSTANCE_COUNT, value);
    }

    @Override
    public PropertyNode getCreatableNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ProgramStateMachineType.CREATABLE);
        return propertyNode.orElse(null);
    }

    @Override
    public Boolean getCreatable() {
        Optional<Boolean> propertyValue = this.getProperty(ProgramStateMachineType.CREATABLE);
        return propertyValue.orElse(null);
    }

    @Override
    public void setCreatable(Boolean value) {
        this.setProperty(ProgramStateMachineType.CREATABLE, value);
    }

    @Override
    public StateNode getRunningNode() {
        Optional<ObjectNode> component = this.getObjectComponent("http://opcfoundation.org/UA/", "Running");
        return component.orElse(null);
    }

    @Override
    public StateNode getSuspendedNode() {
        Optional<ObjectNode> component = this.getObjectComponent("http://opcfoundation.org/UA/", "Suspended");
        return component.orElse(null);
    }

    @Override
    public BaseObjectNode getFinalResultDataNode() {
        Optional<ObjectNode> component = this.getObjectComponent("http://opcfoundation.org/UA/", "FinalResultData");
        return component.orElse(null);
    }

    @Override
    public TransitionNode getHaltedToReadyNode() {
        Optional<ObjectNode> component = this.getObjectComponent("http://opcfoundation.org/UA/", "HaltedToReady");
        return component.orElse(null);
    }

    @Override
    public StateNode getHaltedNode() {
        Optional<ObjectNode> component = this.getObjectComponent("http://opcfoundation.org/UA/", "Halted");
        return component.orElse(null);
    }

    @Override
    public StateNode getReadyNode() {
        Optional<ObjectNode> component = this.getObjectComponent("http://opcfoundation.org/UA/", "Ready");
        return component.orElse(null);
    }

    @Override
    public TransitionNode getRunningToSuspendedNode() {
        Optional<ObjectNode> component = this.getObjectComponent("http://opcfoundation.org/UA/", "RunningToSuspended");
        return component.orElse(null);
    }

    @Override
    public TransitionNode getReadyToRunningNode() {
        Optional<ObjectNode> component = this.getObjectComponent("http://opcfoundation.org/UA/", "ReadyToRunning");
        return component.orElse(null);
    }

    @Override
    public TransitionNode getRunningToHaltedNode() {
        Optional<ObjectNode> component = this.getObjectComponent("http://opcfoundation.org/UA/", "RunningToHalted");
        return component.orElse(null);
    }

    @Override
    public TransitionNode getRunningToReadyNode() {
        Optional<ObjectNode> component = this.getObjectComponent("http://opcfoundation.org/UA/", "RunningToReady");
        return component.orElse(null);
    }

    @Override
    public UaMethodNode getResetMethodNode() {
        Optional<UaNode> methodNode = this.findNode("http://opcfoundation.org/UA/", "Reset", node -> node instanceof UaMethodNode, Reference.HAS_COMPONENT_PREDICATE);
        return methodNode.orElse(null);
    }

    @Override
    public TransitionNode getSuspendedToRunningNode() {
        Optional<ObjectNode> component = this.getObjectComponent("http://opcfoundation.org/UA/", "SuspendedToRunning");
        return component.orElse(null);
    }

    @Override
    public TransitionNode getSuspendedToHaltedNode() {
        Optional<ObjectNode> component = this.getObjectComponent("http://opcfoundation.org/UA/", "SuspendedToHalted");
        return component.orElse(null);
    }

    @Override
    public FiniteStateVariableNode getCurrentStateNode() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "CurrentState");
        return component.orElse(null);
    }

    @Override
    public LocalizedText getCurrentState() {
        Optional<VariableNode> component = this.getVariableComponent("CurrentState");
        return component.map(node -> (LocalizedText)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public void setCurrentState(LocalizedText value) {
        this.getVariableComponent("CurrentState").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }

    @Override
    public TransitionNode getSuspendedToReadyNode() {
        Optional<ObjectNode> component = this.getObjectComponent("http://opcfoundation.org/UA/", "SuspendedToReady");
        return component.orElse(null);
    }

    @Override
    public UaMethodNode getStartMethodNode() {
        Optional<UaNode> methodNode = this.findNode("http://opcfoundation.org/UA/", "Start", node -> node instanceof UaMethodNode, Reference.HAS_COMPONENT_PREDICATE);
        return methodNode.orElse(null);
    }

    @Override
    public UaMethodNode getResumeMethodNode() {
        Optional<UaNode> methodNode = this.findNode("http://opcfoundation.org/UA/", "Resume", node -> node instanceof UaMethodNode, Reference.HAS_COMPONENT_PREDICATE);
        return methodNode.orElse(null);
    }

    @Override
    public TransitionNode getReadyToHaltedNode() {
        Optional<ObjectNode> component = this.getObjectComponent("http://opcfoundation.org/UA/", "ReadyToHalted");
        return component.orElse(null);
    }

    @Override
    public ProgramDiagnosticNode getProgramDiagnosticsNode() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "ProgramDiagnostics");
        return component.orElse(null);
    }

    @Override
    public ProgramDiagnosticDataType getProgramDiagnostics() {
        Optional<VariableNode> component = this.getVariableComponent("ProgramDiagnostics");
        return component.map(node -> (ProgramDiagnosticDataType)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public void setProgramDiagnostics(ProgramDiagnosticDataType value) {
        this.getVariableComponent("ProgramDiagnostics").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }

    @Override
    public FiniteTransitionVariableNode getLastTransitionNode() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "LastTransition");
        return component.orElse(null);
    }

    @Override
    public LocalizedText getLastTransition() {
        Optional<VariableNode> component = this.getVariableComponent("LastTransition");
        return component.map(node -> (LocalizedText)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public void setLastTransition(LocalizedText value) {
        this.getVariableComponent("LastTransition").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }

    @Override
    public UaMethodNode getSuspendMethodNode() {
        Optional<UaNode> methodNode = this.findNode("http://opcfoundation.org/UA/", "Suspend", node -> node instanceof UaMethodNode, Reference.HAS_COMPONENT_PREDICATE);
        return methodNode.orElse(null);
    }

    @Override
    public UaMethodNode getHaltMethodNode() {
        Optional<UaNode> methodNode = this.findNode("http://opcfoundation.org/UA/", "Halt", node -> node instanceof UaMethodNode, Reference.HAS_COMPONENT_PREDICATE);
        return methodNode.orElse(null);
    }
}

