/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;

public class Tree<A> {
    private final List<Tree<A>> children = new ArrayList<Tree<A>>();
    private final Tree<A> parent;
    private final A value;

    public Tree(@Nullable Tree<A> parent, A value) {
        this.parent = parent;
        this.value = value;
    }

    public Tree<A> addChild(A value) {
        return this.addChild(new Tree<A>(this, value));
    }

    public Tree<A> addChild(Tree<A> child) {
        this.children.add(child);
        return child;
    }

    @Nullable
    public Tree<A> getParent() {
        return this.parent;
    }

    public List<Tree<A>> getChildren() {
        return this.children;
    }

    public A getValue() {
        return this.value;
    }

    public void traverse(Consumer<A> c) {
        Tree.traverse(this, c);
    }

    public void traverse(BiConsumer<A, A> c) {
        Tree.traverse(this, c);
    }

    public <B> Tree<B> map(Function<A, B> f) {
        return Tree.map(this, f);
    }

    private static <A, B> Tree<B> map(Tree<A> tA, Function<A, B> f) {
        Tree<B> tB = new Tree<B>(null, f.apply(tA.value));
        Tree.map(tA, tB, f);
        return tB;
    }

    private static <A, B> void map(Tree<A> tA, Tree<B> tB, Function<A, B> f) {
        tA.children.forEach(cA -> {
            Tree cB = tB.addChild(f.apply(cA.value));
            Tree.map(cA, cB, f);
        });
    }

    private static <T> void traverse(Tree<T> tree, Consumer<T> c) {
        Object value = tree.value;
        c.accept(value);
        tree.children.forEach(t -> Tree.traverse(t, c));
    }

    private static <T> void traverse(Tree<T> tree, BiConsumer<T, T> c) {
        Object parentValue = tree.parent != null ? (Object)tree.parent.value : null;
        Object value = tree.value;
        c.accept(value, parentValue);
        tree.children.forEach(t -> Tree.traverse(t, c));
    }
}

