/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;

public class SamplingIntervalDiagnosticsDataType
implements UaStructure {
    public static final NodeId TypeId = Identifiers.SamplingIntervalDiagnosticsDataType;
    public static final NodeId BinaryEncodingId = Identifiers.SamplingIntervalDiagnosticsDataType_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.SamplingIntervalDiagnosticsDataType_Encoding_DefaultXml;
    protected final Double samplingInterval;
    protected final UInteger monitoredItemCount;
    protected final UInteger maxMonitoredItemCount;
    protected final UInteger disabledMonitoredItemCount;

    public SamplingIntervalDiagnosticsDataType() {
        this.samplingInterval = null;
        this.monitoredItemCount = null;
        this.maxMonitoredItemCount = null;
        this.disabledMonitoredItemCount = null;
    }

    public SamplingIntervalDiagnosticsDataType(Double samplingInterval, UInteger monitoredItemCount, UInteger maxMonitoredItemCount, UInteger disabledMonitoredItemCount) {
        this.samplingInterval = samplingInterval;
        this.monitoredItemCount = monitoredItemCount;
        this.maxMonitoredItemCount = maxMonitoredItemCount;
        this.disabledMonitoredItemCount = disabledMonitoredItemCount;
    }

    public Double getSamplingInterval() {
        return this.samplingInterval;
    }

    public UInteger getMonitoredItemCount() {
        return this.monitoredItemCount;
    }

    public UInteger getMaxMonitoredItemCount() {
        return this.maxMonitoredItemCount;
    }

    public UInteger getDisabledMonitoredItemCount() {
        return this.disabledMonitoredItemCount;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("SamplingInterval", (Object)this.samplingInterval).add("MonitoredItemCount", (Object)this.monitoredItemCount).add("MaxMonitoredItemCount", (Object)this.maxMonitoredItemCount).add("DisabledMonitoredItemCount", (Object)this.disabledMonitoredItemCount).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<SamplingIntervalDiagnosticsDataType> {
        @Override
        public Class<SamplingIntervalDiagnosticsDataType> getType() {
            return SamplingIntervalDiagnosticsDataType.class;
        }

        @Override
        public SamplingIntervalDiagnosticsDataType decode(UaDecoder decoder) throws UaSerializationException {
            Double samplingInterval = decoder.readDouble("SamplingInterval");
            UInteger monitoredItemCount = decoder.readUInt32("MonitoredItemCount");
            UInteger maxMonitoredItemCount = decoder.readUInt32("MaxMonitoredItemCount");
            UInteger disabledMonitoredItemCount = decoder.readUInt32("DisabledMonitoredItemCount");
            return new SamplingIntervalDiagnosticsDataType(samplingInterval, monitoredItemCount, maxMonitoredItemCount, disabledMonitoredItemCount);
        }

        @Override
        public void encode(SamplingIntervalDiagnosticsDataType value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeDouble("SamplingInterval", value.samplingInterval);
            encoder.writeUInt32("MonitoredItemCount", value.monitoredItemCount);
            encoder.writeUInt32("MaxMonitoredItemCount", value.maxMonitoredItemCount);
            encoder.writeUInt32("DisabledMonitoredItemCount", value.disabledMonitoredItemCount);
        }
    }
}

