/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.QueryDataSet;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;

public class QueryNextResponse
implements UaResponseMessage {
    public static final NodeId TypeId = Identifiers.QueryNextResponse;
    public static final NodeId BinaryEncodingId = Identifiers.QueryNextResponse_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.QueryNextResponse_Encoding_DefaultXml;
    protected final ResponseHeader responseHeader;
    protected final QueryDataSet[] queryDataSets;
    protected final ByteString revisedContinuationPoint;

    public QueryNextResponse() {
        this.responseHeader = null;
        this.queryDataSets = null;
        this.revisedContinuationPoint = null;
    }

    public QueryNextResponse(ResponseHeader responseHeader, QueryDataSet[] queryDataSets, ByteString revisedContinuationPoint) {
        this.responseHeader = responseHeader;
        this.queryDataSets = queryDataSets;
        this.revisedContinuationPoint = revisedContinuationPoint;
    }

    @Override
    public ResponseHeader getResponseHeader() {
        return this.responseHeader;
    }

    @Nullable
    public QueryDataSet[] getQueryDataSets() {
        return this.queryDataSets;
    }

    public ByteString getRevisedContinuationPoint() {
        return this.revisedContinuationPoint;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ResponseHeader", (Object)this.responseHeader).add("QueryDataSets", (Object)this.queryDataSets).add("RevisedContinuationPoint", (Object)this.revisedContinuationPoint).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<QueryNextResponse> {
        @Override
        public Class<QueryNextResponse> getType() {
            return QueryNextResponse.class;
        }

        @Override
        public QueryNextResponse decode(UaDecoder decoder) throws UaSerializationException {
            ResponseHeader responseHeader = decoder.readBuiltinStruct("ResponseHeader", ResponseHeader.class);
            QueryDataSet[] queryDataSets = (QueryDataSet[])decoder.readBuiltinStructArray("QueryDataSets", QueryDataSet.class);
            ByteString revisedContinuationPoint = decoder.readByteString("RevisedContinuationPoint");
            return new QueryNextResponse(responseHeader, queryDataSets, revisedContinuationPoint);
        }

        @Override
        public void encode(QueryNextResponse value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeBuiltinStruct("ResponseHeader", value.responseHeader, ResponseHeader.class);
            encoder.writeBuiltinStructArray("QueryDataSets", value.queryDataSets, QueryDataSet.class);
            encoder.writeByteString("RevisedContinuationPoint", value.revisedContinuationPoint);
        }
    }
}

