/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;

public class MonitoringParameters
implements UaStructure {
    public static final NodeId TypeId = Identifiers.MonitoringParameters;
    public static final NodeId BinaryEncodingId = Identifiers.MonitoringParameters_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.MonitoringParameters_Encoding_DefaultXml;
    protected final UInteger clientHandle;
    protected final Double samplingInterval;
    protected final ExtensionObject filter;
    protected final UInteger queueSize;
    protected final Boolean discardOldest;

    public MonitoringParameters() {
        this.clientHandle = null;
        this.samplingInterval = null;
        this.filter = null;
        this.queueSize = null;
        this.discardOldest = null;
    }

    public MonitoringParameters(UInteger clientHandle, Double samplingInterval, ExtensionObject filter, UInteger queueSize, Boolean discardOldest) {
        this.clientHandle = clientHandle;
        this.samplingInterval = samplingInterval;
        this.filter = filter;
        this.queueSize = queueSize;
        this.discardOldest = discardOldest;
    }

    public UInteger getClientHandle() {
        return this.clientHandle;
    }

    public Double getSamplingInterval() {
        return this.samplingInterval;
    }

    public ExtensionObject getFilter() {
        return this.filter;
    }

    public UInteger getQueueSize() {
        return this.queueSize;
    }

    public Boolean getDiscardOldest() {
        return this.discardOldest;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ClientHandle", (Object)this.clientHandle).add("SamplingInterval", (Object)this.samplingInterval).add("Filter", (Object)this.filter).add("QueueSize", (Object)this.queueSize).add("DiscardOldest", (Object)this.discardOldest).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<MonitoringParameters> {
        @Override
        public Class<MonitoringParameters> getType() {
            return MonitoringParameters.class;
        }

        @Override
        public MonitoringParameters decode(UaDecoder decoder) throws UaSerializationException {
            UInteger clientHandle = decoder.readUInt32("ClientHandle");
            Double samplingInterval = decoder.readDouble("SamplingInterval");
            ExtensionObject filter = decoder.readExtensionObject("Filter");
            UInteger queueSize = decoder.readUInt32("QueueSize");
            Boolean discardOldest = decoder.readBoolean("DiscardOldest");
            return new MonitoringParameters(clientHandle, samplingInterval, filter, queueSize, discardOldest);
        }

        @Override
        public void encode(MonitoringParameters value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeUInt32("ClientHandle", value.clientHandle);
            encoder.writeDouble("SamplingInterval", value.samplingInterval);
            encoder.writeExtensionObject("Filter", value.filter);
            encoder.writeUInt32("QueueSize", value.queueSize);
            encoder.writeBoolean("DiscardOldest", value.discardOldest);
        }
    }
}

