/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.DiscoveryConfiguration;

public class MdnsDiscoveryConfiguration
extends DiscoveryConfiguration {
    public static final NodeId TypeId = Identifiers.MdnsDiscoveryConfiguration;
    public static final NodeId BinaryEncodingId = Identifiers.MdnsDiscoveryConfiguration_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.MdnsDiscoveryConfiguration_Encoding_DefaultXml;
    protected final String mdnsServerName;
    protected final String[] serverCapabilities;

    public MdnsDiscoveryConfiguration() {
        this.mdnsServerName = null;
        this.serverCapabilities = null;
    }

    public MdnsDiscoveryConfiguration(String mdnsServerName, String[] serverCapabilities) {
        this.mdnsServerName = mdnsServerName;
        this.serverCapabilities = serverCapabilities;
    }

    public String getMdnsServerName() {
        return this.mdnsServerName;
    }

    @Nullable
    public String[] getServerCapabilities() {
        return this.serverCapabilities;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("MdnsServerName", (Object)this.mdnsServerName).add("ServerCapabilities", (Object)this.serverCapabilities).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<MdnsDiscoveryConfiguration> {
        @Override
        public Class<MdnsDiscoveryConfiguration> getType() {
            return MdnsDiscoveryConfiguration.class;
        }

        @Override
        public MdnsDiscoveryConfiguration decode(UaDecoder decoder) throws UaSerializationException {
            String mdnsServerName = decoder.readString("MdnsServerName");
            String[] serverCapabilities = decoder.readArray("ServerCapabilities", decoder::readString, String.class);
            return new MdnsDiscoveryConfiguration(mdnsServerName, serverCapabilities);
        }

        @Override
        public void encode(MdnsDiscoveryConfiguration value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeString("MdnsServerName", value.mdnsServerName);
            encoder.writeArray("ServerCapabilities", value.serverCapabilities, encoder::writeString);
        }
    }
}

