/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;

public class GetEndpointsResponse
implements UaResponseMessage {
    public static final NodeId TypeId = Identifiers.GetEndpointsResponse;
    public static final NodeId BinaryEncodingId = Identifiers.GetEndpointsResponse_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.GetEndpointsResponse_Encoding_DefaultXml;
    protected final ResponseHeader responseHeader;
    protected final EndpointDescription[] endpoints;

    public GetEndpointsResponse() {
        this.responseHeader = null;
        this.endpoints = null;
    }

    public GetEndpointsResponse(ResponseHeader responseHeader, EndpointDescription[] endpoints) {
        this.responseHeader = responseHeader;
        this.endpoints = endpoints;
    }

    @Override
    public ResponseHeader getResponseHeader() {
        return this.responseHeader;
    }

    @Nullable
    public EndpointDescription[] getEndpoints() {
        return this.endpoints;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ResponseHeader", (Object)this.responseHeader).add("Endpoints", (Object)this.endpoints).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<GetEndpointsResponse> {
        @Override
        public Class<GetEndpointsResponse> getType() {
            return GetEndpointsResponse.class;
        }

        @Override
        public GetEndpointsResponse decode(UaDecoder decoder) throws UaSerializationException {
            ResponseHeader responseHeader = decoder.readBuiltinStruct("ResponseHeader", ResponseHeader.class);
            EndpointDescription[] endpoints = (EndpointDescription[])decoder.readBuiltinStructArray("Endpoints", EndpointDescription.class);
            return new GetEndpointsResponse(responseHeader, endpoints);
        }

        @Override
        public void encode(GetEndpointsResponse value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeBuiltinStruct("ResponseHeader", value.responseHeader, ResponseHeader.class);
            encoder.writeBuiltinStructArray("Endpoints", value.endpoints, EndpointDescription.class);
        }
    }
}

