/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.enumerated;

import com.google.common.collect.ImmutableMap;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEnumeration;

public enum MessageSecurityMode implements UaEnumeration
{
    Invalid(0),
    None(1),
    Sign(2),
    SignAndEncrypt(3);

    private final int value;
    private static final ImmutableMap<Integer, MessageSecurityMode> VALUES;

    private MessageSecurityMode(int value) {
        this.value = value;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static MessageSecurityMode from(Integer value) {
        if (value == null) {
            return null;
        }
        return (MessageSecurityMode)VALUES.getOrDefault((Object)value, null);
    }

    public static void encode(MessageSecurityMode messageSecurityMode, UaEncoder encoder) {
        encoder.writeInt32(null, messageSecurityMode.getValue());
    }

    public static MessageSecurityMode decode(UaDecoder decoder) {
        int value = decoder.readInt32(null);
        return (MessageSecurityMode)VALUES.getOrDefault((Object)value, null);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (MessageSecurityMode e : MessageSecurityMode.values()) {
            builder.put((Object)e.getValue(), (Object)e);
        }
        VALUES = builder.build();
    }
}

