/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.WriteValue;

public class WriteRequest
implements UaRequestMessage {
    public static final NodeId TypeId = Identifiers.WriteRequest;
    public static final NodeId BinaryEncodingId = Identifiers.WriteRequest_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.WriteRequest_Encoding_DefaultXml;
    protected final RequestHeader requestHeader;
    protected final WriteValue[] nodesToWrite;

    public WriteRequest() {
        this.requestHeader = null;
        this.nodesToWrite = null;
    }

    public WriteRequest(RequestHeader requestHeader, WriteValue[] nodesToWrite) {
        this.requestHeader = requestHeader;
        this.nodesToWrite = nodesToWrite;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    @Nullable
    public WriteValue[] getNodesToWrite() {
        return this.nodesToWrite;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("RequestHeader", (Object)this.requestHeader).add("NodesToWrite", (Object)this.nodesToWrite).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<WriteRequest> {
        @Override
        public Class<WriteRequest> getType() {
            return WriteRequest.class;
        }

        @Override
        public WriteRequest decode(UaDecoder decoder) throws UaSerializationException {
            RequestHeader requestHeader = decoder.readBuiltinStruct("RequestHeader", RequestHeader.class);
            WriteValue[] nodesToWrite = (WriteValue[])decoder.readBuiltinStructArray("NodesToWrite", WriteValue.class);
            return new WriteRequest(requestHeader, nodesToWrite);
        }

        @Override
        public void encode(WriteRequest value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeBuiltinStruct("RequestHeader", value.requestHeader, RequestHeader.class);
            encoder.writeBuiltinStructArray("NodesToWrite", value.nodesToWrite, WriteValue.class);
        }
    }
}

