/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;

public class SetTriggeringResponse
implements UaResponseMessage {
    public static final NodeId TypeId = Identifiers.SetTriggeringResponse;
    public static final NodeId BinaryEncodingId = Identifiers.SetTriggeringResponse_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.SetTriggeringResponse_Encoding_DefaultXml;
    protected final ResponseHeader responseHeader;
    protected final StatusCode[] addResults;
    protected final DiagnosticInfo[] addDiagnosticInfos;
    protected final StatusCode[] removeResults;
    protected final DiagnosticInfo[] removeDiagnosticInfos;

    public SetTriggeringResponse() {
        this.responseHeader = null;
        this.addResults = null;
        this.addDiagnosticInfos = null;
        this.removeResults = null;
        this.removeDiagnosticInfos = null;
    }

    public SetTriggeringResponse(ResponseHeader responseHeader, StatusCode[] addResults, DiagnosticInfo[] addDiagnosticInfos, StatusCode[] removeResults, DiagnosticInfo[] removeDiagnosticInfos) {
        this.responseHeader = responseHeader;
        this.addResults = addResults;
        this.addDiagnosticInfos = addDiagnosticInfos;
        this.removeResults = removeResults;
        this.removeDiagnosticInfos = removeDiagnosticInfos;
    }

    @Override
    public ResponseHeader getResponseHeader() {
        return this.responseHeader;
    }

    @Nullable
    public StatusCode[] getAddResults() {
        return this.addResults;
    }

    @Nullable
    public DiagnosticInfo[] getAddDiagnosticInfos() {
        return this.addDiagnosticInfos;
    }

    @Nullable
    public StatusCode[] getRemoveResults() {
        return this.removeResults;
    }

    @Nullable
    public DiagnosticInfo[] getRemoveDiagnosticInfos() {
        return this.removeDiagnosticInfos;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ResponseHeader", (Object)this.responseHeader).add("AddResults", (Object)this.addResults).add("AddDiagnosticInfos", (Object)this.addDiagnosticInfos).add("RemoveResults", (Object)this.removeResults).add("RemoveDiagnosticInfos", (Object)this.removeDiagnosticInfos).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<SetTriggeringResponse> {
        @Override
        public Class<SetTriggeringResponse> getType() {
            return SetTriggeringResponse.class;
        }

        @Override
        public SetTriggeringResponse decode(UaDecoder decoder) throws UaSerializationException {
            ResponseHeader responseHeader = decoder.readBuiltinStruct("ResponseHeader", ResponseHeader.class);
            StatusCode[] addResults = decoder.readArray("AddResults", decoder::readStatusCode, StatusCode.class);
            DiagnosticInfo[] addDiagnosticInfos = decoder.readArray("AddDiagnosticInfos", decoder::readDiagnosticInfo, DiagnosticInfo.class);
            StatusCode[] removeResults = decoder.readArray("RemoveResults", decoder::readStatusCode, StatusCode.class);
            DiagnosticInfo[] removeDiagnosticInfos = decoder.readArray("RemoveDiagnosticInfos", decoder::readDiagnosticInfo, DiagnosticInfo.class);
            return new SetTriggeringResponse(responseHeader, addResults, addDiagnosticInfos, removeResults, removeDiagnosticInfos);
        }

        @Override
        public void encode(SetTriggeringResponse value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeBuiltinStruct("ResponseHeader", value.responseHeader, ResponseHeader.class);
            encoder.writeArray("AddResults", value.addResults, encoder::writeStatusCode);
            encoder.writeArray("AddDiagnosticInfos", value.addDiagnosticInfos, encoder::writeDiagnosticInfo);
            encoder.writeArray("RemoveResults", value.removeResults, encoder::writeStatusCode);
            encoder.writeArray("RemoveDiagnosticInfos", value.removeDiagnosticInfos, encoder::writeDiagnosticInfo);
        }
    }
}

