/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;

public class ServerOnNetwork
implements UaStructure {
    public static final NodeId TypeId = Identifiers.ServerOnNetwork;
    public static final NodeId BinaryEncodingId = Identifiers.ServerOnNetwork_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.ServerOnNetwork_Encoding_DefaultXml;
    protected final UInteger recordId;
    protected final String serverName;
    protected final String discoveryUrl;
    protected final String[] serverCapabilities;

    public ServerOnNetwork() {
        this.recordId = null;
        this.serverName = null;
        this.discoveryUrl = null;
        this.serverCapabilities = null;
    }

    public ServerOnNetwork(UInteger recordId, String serverName, String discoveryUrl, String[] serverCapabilities) {
        this.recordId = recordId;
        this.serverName = serverName;
        this.discoveryUrl = discoveryUrl;
        this.serverCapabilities = serverCapabilities;
    }

    public UInteger getRecordId() {
        return this.recordId;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getDiscoveryUrl() {
        return this.discoveryUrl;
    }

    @Nullable
    public String[] getServerCapabilities() {
        return this.serverCapabilities;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("RecordId", (Object)this.recordId).add("ServerName", (Object)this.serverName).add("DiscoveryUrl", (Object)this.discoveryUrl).add("ServerCapabilities", (Object)this.serverCapabilities).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<ServerOnNetwork> {
        @Override
        public Class<ServerOnNetwork> getType() {
            return ServerOnNetwork.class;
        }

        @Override
        public ServerOnNetwork decode(UaDecoder decoder) throws UaSerializationException {
            UInteger recordId = decoder.readUInt32("RecordId");
            String serverName = decoder.readString("ServerName");
            String discoveryUrl = decoder.readString("DiscoveryUrl");
            String[] serverCapabilities = decoder.readArray("ServerCapabilities", decoder::readString, String.class);
            return new ServerOnNetwork(recordId, serverName, discoveryUrl, serverCapabilities);
        }

        @Override
        public void encode(ServerOnNetwork value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeUInt32("RecordId", value.recordId);
            encoder.writeString("ServerName", value.serverName);
            encoder.writeString("DiscoveryUrl", value.discoveryUrl);
            encoder.writeArray("ServerCapabilities", value.serverCapabilities, encoder::writeString);
        }
    }
}

