/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;

public class HistoryReadResult
implements UaStructure {
    public static final NodeId TypeId = Identifiers.HistoryReadResult;
    public static final NodeId BinaryEncodingId = Identifiers.HistoryReadResult_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.HistoryReadResult_Encoding_DefaultXml;
    protected final StatusCode statusCode;
    protected final ByteString continuationPoint;
    protected final ExtensionObject historyData;

    public HistoryReadResult() {
        this.statusCode = null;
        this.continuationPoint = null;
        this.historyData = null;
    }

    public HistoryReadResult(StatusCode statusCode, ByteString continuationPoint, ExtensionObject historyData) {
        this.statusCode = statusCode;
        this.continuationPoint = continuationPoint;
        this.historyData = historyData;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public ByteString getContinuationPoint() {
        return this.continuationPoint;
    }

    public ExtensionObject getHistoryData() {
        return this.historyData;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("StatusCode", (Object)this.statusCode).add("ContinuationPoint", (Object)this.continuationPoint).add("HistoryData", (Object)this.historyData).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<HistoryReadResult> {
        @Override
        public Class<HistoryReadResult> getType() {
            return HistoryReadResult.class;
        }

        @Override
        public HistoryReadResult decode(UaDecoder decoder) throws UaSerializationException {
            StatusCode statusCode = decoder.readStatusCode("StatusCode");
            ByteString continuationPoint = decoder.readByteString("ContinuationPoint");
            ExtensionObject historyData = decoder.readExtensionObject("HistoryData");
            return new HistoryReadResult(statusCode, continuationPoint, historyData);
        }

        @Override
        public void encode(HistoryReadResult value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeStatusCode("StatusCode", value.statusCode);
            encoder.writeByteString("ContinuationPoint", value.continuationPoint);
            encoder.writeExtensionObject("HistoryData", value.historyData);
        }
    }
}

