/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.FilterOperand;

public class ElementOperand
extends FilterOperand {
    public static final NodeId TypeId = Identifiers.ElementOperand;
    public static final NodeId BinaryEncodingId = Identifiers.ElementOperand_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.ElementOperand_Encoding_DefaultXml;
    protected final UInteger index;

    public ElementOperand() {
        this.index = null;
    }

    public ElementOperand(UInteger index) {
        this.index = index;
    }

    public UInteger getIndex() {
        return this.index;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("Index", (Object)this.index).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<ElementOperand> {
        @Override
        public Class<ElementOperand> getType() {
            return ElementOperand.class;
        }

        @Override
        public ElementOperand decode(UaDecoder decoder) throws UaSerializationException {
            UInteger index = decoder.readUInt32("Index");
            return new ElementOperand(index);
        }

        @Override
        public void encode(ElementOperand value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeUInt32("Index", value.index);
        }
    }
}

