/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.enumerated;

import com.google.common.collect.ImmutableMap;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEnumeration;

public enum PerformUpdateType implements UaEnumeration
{
    Insert(1),
    Replace(2),
    Update(3),
    Remove(4);

    private final int value;
    private static final ImmutableMap<Integer, PerformUpdateType> VALUES;

    private PerformUpdateType(int value) {
        this.value = value;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static PerformUpdateType from(Integer value) {
        if (value == null) {
            return null;
        }
        return (PerformUpdateType)VALUES.getOrDefault((Object)value, null);
    }

    public static void encode(PerformUpdateType performUpdateType, UaEncoder encoder) {
        encoder.writeInt32(null, performUpdateType.getValue());
    }

    public static PerformUpdateType decode(UaDecoder decoder) {
        int value = decoder.readInt32(null);
        return (PerformUpdateType)VALUES.getOrDefault((Object)value, null);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (PerformUpdateType e : PerformUpdateType.values()) {
            builder.put((Object)e.getValue(), (Object)e);
        }
        VALUES = builder.build();
    }
}

