/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.builtin;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.primitives.UnsignedInteger;
import java.util.Optional;
import java.util.UUID;
import javax.xml.bind.DatatypeConverter;
import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.UaRuntimeException;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.IdType;

public final class ExpandedNodeId {
    public static final ExpandedNodeId NULL_VALUE = new ExpandedNodeId(NodeId.NULL_VALUE, null, 0L);
    private final NodeId nodeId;
    private final String namespaceUri;
    private final long serverIndex;

    public ExpandedNodeId(NodeId nodeId) {
        this(nodeId, null, 0L);
    }

    public ExpandedNodeId(NodeId nodeId, String namespaceUri) {
        this(nodeId, namespaceUri, 0L);
    }

    public ExpandedNodeId(NodeId nodeId, String namespaceUri, long serverIndex) {
        this.nodeId = nodeId;
        this.namespaceUri = namespaceUri;
        this.serverIndex = serverIndex;
    }

    public ExpandedNodeId(UShort namespaceIndex, UInteger identifier, String namespaceUri, long serverIndex) {
        Preconditions.checkArgument((identifier.longValue() >= 0L && identifier.longValue() <= UnsignedInteger.MAX_VALUE.longValue() ? 1 : 0) != 0);
        this.nodeId = new NodeId(namespaceIndex, identifier);
        this.namespaceUri = namespaceUri;
        this.serverIndex = serverIndex;
    }

    public ExpandedNodeId(int namespaceIndex, int identifier, String namespaceUri, long serverIndex) {
        this(Unsigned.ushort(namespaceIndex), Unsigned.uint(identifier), namespaceUri, serverIndex);
    }

    public ExpandedNodeId(UShort namespaceIndex, String identifier, String namespaceUri, long serverIndex) {
        Preconditions.checkNotNull((Object)identifier);
        this.nodeId = new NodeId(namespaceIndex, identifier);
        this.namespaceUri = namespaceUri;
        this.serverIndex = serverIndex;
    }

    public ExpandedNodeId(int namespaceIndex, String identifier, String namespaceUri, long serverIndex) {
        this(Unsigned.ushort(namespaceIndex), identifier, namespaceUri, serverIndex);
    }

    public ExpandedNodeId(UShort namespaceIndex, UUID identifier, String namespaceUri, long serverIndex) {
        Preconditions.checkNotNull((Object)identifier);
        this.nodeId = new NodeId(namespaceIndex, identifier);
        this.namespaceUri = namespaceUri;
        this.serverIndex = serverIndex;
    }

    public ExpandedNodeId(int namespaceIndex, UUID identifier, String namespaceUri, long serverIndex) {
        this(Unsigned.ushort(namespaceIndex), identifier, namespaceUri, serverIndex);
    }

    public ExpandedNodeId(UShort namespaceIndex, ByteString identifier, String namespaceUri, long serverIndex) {
        Preconditions.checkNotNull((Object)identifier);
        this.nodeId = new NodeId(namespaceIndex, identifier);
        this.namespaceUri = namespaceUri;
        this.serverIndex = serverIndex;
    }

    public ExpandedNodeId(int namespaceIndex, ByteString identifier, String namespaceUri, long serverIndex) {
        this(Unsigned.ushort(namespaceIndex), identifier, namespaceUri, serverIndex);
    }

    public UShort getNamespaceIndex() {
        return this.nodeId.getNamespaceIndex();
    }

    public Object getIdentifier() {
        return this.nodeId.getIdentifier();
    }

    public IdType getType() {
        return this.nodeId.getType();
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    public long getServerIndex() {
        return this.serverIndex;
    }

    public boolean isLocal() {
        return this.serverIndex == 0L;
    }

    public boolean isNull() {
        return this.nodeId.isNull();
    }

    public boolean isNotNull() {
        return !this.isNull();
    }

    @Deprecated
    public Optional<NodeId> local() {
        return this.isLocal() ? Optional.of(this.nodeId) : Optional.empty();
    }

    public Optional<NodeId> local(NamespaceTable namespaceTable) {
        if (this.isLocal()) {
            if (this.namespaceUri == null || this.namespaceUri.isEmpty()) {
                NodeId nodeId = new NodeId(this.getNamespaceIndex(), this.nodeId.getIdentifier());
                return Optional.of(nodeId);
            }
            UShort namespaceIndex = namespaceTable.getIndex(this.namespaceUri);
            if (namespaceIndex == null) {
                return Optional.empty();
            }
            NodeId nodeId = new NodeId(namespaceIndex, this.nodeId.getIdentifier());
            return Optional.of(nodeId);
        }
        return Optional.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExpandedNodeId that = (ExpandedNodeId)o;
        return Objects.equal((Object)this.serverIndex, (Object)that.serverIndex) && Objects.equal((Object)this.nodeId.getIdentifier(), (Object)that.nodeId.getIdentifier()) && (Objects.equal((Object)this.namespaceUri, (Object)that.namespaceUri) || Objects.equal((Object)this.nodeId.getNamespaceIndex(), (Object)that.nodeId.getNamespaceIndex()));
    }

    public int hashCode() {
        int result = this.nodeId != null ? this.nodeId.hashCode() : 0;
        result = 31 * result + (this.namespaceUri != null ? this.namespaceUri.hashCode() : 0);
        result = 31 * result + (int)(this.serverIndex ^ this.serverIndex >>> 32);
        return result;
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this);
        if (this.namespaceUri != null && this.namespaceUri.length() > 0) {
            helper.add("ns", (Object)this.namespaceUri);
        } else {
            helper.add("ns", (Object)this.getNamespaceIndex());
        }
        helper.add("id", this.getIdentifier());
        helper.add("serverIndex", this.getServerIndex());
        return helper.toString();
    }

    public String toParseableString() {
        StringBuilder sb = new StringBuilder();
        sb.append("svr=").append(this.serverIndex).append(";");
        if (this.namespaceUri != null) {
            sb.append("nsu=").append(this.namespaceUri).append(";");
        } else {
            int namespaceIndex = this.getNamespaceIndex().intValue();
            if (namespaceIndex > 0) {
                sb.append("ns=").append(this.getNamespaceIndex().intValue()).append(";");
            }
        }
        switch (this.getType()) {
            case Numeric: {
                sb.append("i=").append(this.getIdentifier());
                break;
            }
            case String: {
                sb.append("s=").append(this.getIdentifier());
                break;
            }
            case Guid: {
                sb.append("g=").append(this.getIdentifier());
                break;
            }
            case Opaque: {
                ByteString bs = (ByteString)this.getIdentifier();
                if (bs.isNull()) {
                    sb.append("b=");
                    break;
                }
                sb.append("b=").append(DatatypeConverter.printBase64Binary((byte[])bs.bytes()));
                break;
            }
            default: {
                throw new IllegalStateException("IdType " + this.nodeId.getType());
            }
        }
        return sb.toString();
    }

    public static ExpandedNodeId parse(String s) {
        try {
            String[] parts = s.split(";");
            NodeId nodeId = NodeId.parse(parts[parts.length - 1]);
            int serverIndex = 0;
            int namespaceIndex = 0;
            String namespaceUri = null;
            Object identifier = nodeId.getIdentifier();
            for (String part : parts) {
                String[] ss = part.split("=");
                if ("svr".equals(ss[0])) {
                    serverIndex = Integer.parseInt(ss[1]);
                    continue;
                }
                if ("ns".equals(ss[0])) {
                    namespaceIndex = Integer.parseInt(ss[1]);
                    continue;
                }
                if (!"nsu".equals(ss[0])) continue;
                namespaceUri = ss[1];
            }
            switch (nodeId.getType()) {
                case Guid: {
                    return new ExpandedNodeId(namespaceIndex, (UUID)identifier, namespaceUri, (long)serverIndex);
                }
                case Numeric: {
                    return new ExpandedNodeId(namespaceIndex, ((UInteger)identifier).intValue(), namespaceUri, (long)serverIndex);
                }
                case Opaque: {
                    return new ExpandedNodeId(namespaceIndex, (ByteString)identifier, namespaceUri, (long)serverIndex);
                }
                case String: {
                    return new ExpandedNodeId(namespaceIndex, (String)identifier, namespaceUri, (long)serverIndex);
                }
            }
            throw new IllegalStateException("IdType " + nodeId.getType());
        }
        catch (Throwable t) {
            throw new UaRuntimeException(0x80330000L, t);
        }
    }
}

