/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.nodes.objects;

import java.util.Optional;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.BaseEventNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.ConditionVariableNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.PropertyNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.TwoStateVariableNode;
import org.eclipse.milo.opcua.sdk.server.model.types.objects.ConditionType;
import org.eclipse.milo.opcua.sdk.server.nodes.UaMethodNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNodeContext;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;

public class ConditionNode
extends BaseEventNode
implements ConditionType {
    public ConditionNode(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask) {
        super(context, nodeId, browseName, displayName, description, writeMask, userWriteMask);
    }

    public ConditionNode(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, UByte eventNotifier) {
        super(context, nodeId, browseName, displayName, description, writeMask, userWriteMask, eventNotifier);
    }

    @Override
    public PropertyNode getConditionNameNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ConditionType.CONDITION_NAME);
        return propertyNode.orElse(null);
    }

    @Override
    public String getConditionName() {
        Optional<String> propertyValue = this.getProperty(ConditionType.CONDITION_NAME);
        return propertyValue.orElse(null);
    }

    @Override
    public void setConditionName(String value) {
        this.setProperty(ConditionType.CONDITION_NAME, value);
    }

    @Override
    public PropertyNode getClientUserIdNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ConditionType.CLIENT_USER_ID);
        return propertyNode.orElse(null);
    }

    @Override
    public String getClientUserId() {
        Optional<String> propertyValue = this.getProperty(ConditionType.CLIENT_USER_ID);
        return propertyValue.orElse(null);
    }

    @Override
    public void setClientUserId(String value) {
        this.setProperty(ConditionType.CLIENT_USER_ID, value);
    }

    @Override
    public PropertyNode getConditionClassNameNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ConditionType.CONDITION_CLASS_NAME);
        return propertyNode.orElse(null);
    }

    @Override
    public LocalizedText getConditionClassName() {
        Optional<LocalizedText> propertyValue = this.getProperty(ConditionType.CONDITION_CLASS_NAME);
        return propertyValue.orElse(null);
    }

    @Override
    public void setConditionClassName(LocalizedText value) {
        this.setProperty(ConditionType.CONDITION_CLASS_NAME, value);
    }

    @Override
    public PropertyNode getRetainNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ConditionType.RETAIN);
        return propertyNode.orElse(null);
    }

    @Override
    public Boolean getRetain() {
        Optional<Boolean> propertyValue = this.getProperty(ConditionType.RETAIN);
        return propertyValue.orElse(null);
    }

    @Override
    public void setRetain(Boolean value) {
        this.setProperty(ConditionType.RETAIN, value);
    }

    @Override
    public PropertyNode getConditionClassIdNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ConditionType.CONDITION_CLASS_ID);
        return propertyNode.orElse(null);
    }

    @Override
    public NodeId getConditionClassId() {
        Optional<NodeId> propertyValue = this.getProperty(ConditionType.CONDITION_CLASS_ID);
        return propertyValue.orElse(null);
    }

    @Override
    public void setConditionClassId(NodeId value) {
        this.setProperty(ConditionType.CONDITION_CLASS_ID, value);
    }

    @Override
    public PropertyNode getBranchIdNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ConditionType.BRANCH_ID);
        return propertyNode.orElse(null);
    }

    @Override
    public NodeId getBranchId() {
        Optional<NodeId> propertyValue = this.getProperty(ConditionType.BRANCH_ID);
        return propertyValue.orElse(null);
    }

    @Override
    public void setBranchId(NodeId value) {
        this.setProperty(ConditionType.BRANCH_ID, value);
    }

    @Override
    public UaMethodNode getAddCommentMethodNode() {
        Optional<UaNode> methodNode = this.findNode("http://opcfoundation.org/UA/", "AddComment", node -> node instanceof UaMethodNode, Reference.HAS_COMPONENT_PREDICATE);
        return methodNode.orElse(null);
    }

    @Override
    public UaMethodNode getDisableMethodNode() {
        Optional<UaNode> methodNode = this.findNode("http://opcfoundation.org/UA/", "Disable", node -> node instanceof UaMethodNode, Reference.HAS_COMPONENT_PREDICATE);
        return methodNode.orElse(null);
    }

    @Override
    public UaMethodNode getEnableMethodNode() {
        Optional<UaNode> methodNode = this.findNode("http://opcfoundation.org/UA/", "Enable", node -> node instanceof UaMethodNode, Reference.HAS_COMPONENT_PREDICATE);
        return methodNode.orElse(null);
    }

    @Override
    public UaMethodNode getConditionRefreshMethodNode() {
        Optional<UaNode> methodNode = this.findNode("http://opcfoundation.org/UA/", "ConditionRefresh", node -> node instanceof UaMethodNode, Reference.HAS_COMPONENT_PREDICATE);
        return methodNode.orElse(null);
    }

    @Override
    public UaMethodNode getConditionRefresh2MethodNode() {
        Optional<UaNode> methodNode = this.findNode("http://opcfoundation.org/UA/", "ConditionRefresh2", node -> node instanceof UaMethodNode, Reference.HAS_COMPONENT_PREDICATE);
        return methodNode.orElse(null);
    }

    @Override
    public ConditionVariableNode getCommentNode() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "Comment");
        return component.orElse(null);
    }

    @Override
    public LocalizedText getComment() {
        Optional<VariableNode> component = this.getVariableComponent("Comment");
        return component.map(node -> (LocalizedText)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public void setComment(LocalizedText value) {
        this.getVariableComponent("Comment").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }

    @Override
    public TwoStateVariableNode getEnabledStateNode() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "EnabledState");
        return component.orElse(null);
    }

    @Override
    public LocalizedText getEnabledState() {
        Optional<VariableNode> component = this.getVariableComponent("EnabledState");
        return component.map(node -> (LocalizedText)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public void setEnabledState(LocalizedText value) {
        this.getVariableComponent("EnabledState").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }

    @Override
    public ConditionVariableNode getLastSeverityNode() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "LastSeverity");
        return component.orElse(null);
    }

    @Override
    public UShort getLastSeverity() {
        Optional<VariableNode> component = this.getVariableComponent("LastSeverity");
        return component.map(node -> (UShort)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public void setLastSeverity(UShort value) {
        this.getVariableComponent("LastSeverity").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }

    @Override
    public ConditionVariableNode getQualityNode() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "Quality");
        return component.orElse(null);
    }

    @Override
    public StatusCode getQuality() {
        Optional<VariableNode> component = this.getVariableComponent("Quality");
        return component.map(node -> (StatusCode)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public void setQuality(StatusCode value) {
        this.getVariableComponent("Quality").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }
}

