/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.events.operators;

import java.lang.reflect.Array;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.sdk.server.events.FilterContext;
import org.eclipse.milo.opcua.sdk.server.events.OperatorContext;
import org.eclipse.milo.opcua.sdk.server.events.ValidationException;
import org.eclipse.milo.opcua.sdk.server.events.conversions.ImplicitConversions;
import org.eclipse.milo.opcua.sdk.server.events.operators.Operator;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.BaseEventNode;
import org.eclipse.milo.opcua.stack.core.BuiltinDataType;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.structured.FilterOperand;
import org.eclipse.milo.opcua.stack.core.util.ArrayUtil;

public class Equals
implements Operator<Boolean> {
    Equals() {
    }

    @Override
    public void validate(FilterContext context, FilterOperand[] operands) throws ValidationException {
        if (operands.length < 2) {
            throw new ValidationException(2160263168L);
        }
    }

    @Override
    @Nullable
    public Boolean apply(OperatorContext context, BaseEventNode eventNode, FilterOperand[] operands) throws UaException {
        int p1;
        this.validate(context, operands);
        FilterOperand op0 = operands[0];
        FilterOperand op1 = operands[1];
        Object value0 = context.resolve(op0, eventNode);
        Object value1 = context.resolve(op1, eventNode);
        if (value0 == null || value1 == null) {
            return null;
        }
        BuiltinDataType dt0 = Equals.getType(value0);
        BuiltinDataType dt1 = Equals.getType(value1);
        if (dt0 == null || dt1 == null) {
            throw new UaException(0x80010000L);
        }
        int p0 = ImplicitConversions.getPrecedence(dt0);
        if (p0 == (p1 = ImplicitConversions.getPrecedence(dt1))) {
            assert (dt0 == dt1);
            return Equals.equals(value0, value1);
        }
        if (p0 >= p1) {
            Object converted1 = Equals.convert(value1, dt0);
            return Equals.equals(value0, converted1);
        }
        Object converted0 = Equals.convert(value0, dt1);
        return Equals.equals(converted0, value1);
    }

    @Nullable
    private static Object convert(@Nonnull Object value, BuiltinDataType targetType) {
        if (value.getClass().isArray()) {
            return Equals.convertArray(value, targetType);
        }
        return ImplicitConversions.convert(value, targetType);
    }

    private static Object convertArray(@Nonnull Object array, BuiltinDataType targetType) {
        int[] dimensions = ArrayUtil.getDimensions((Object)array);
        Object flattened = ArrayUtil.flatten((Object)array);
        int length = Array.getLength(flattened);
        Object transformed = Array.newInstance(targetType.getBackingClass(), length);
        for (int i = 0; i < length; ++i) {
            Object sourceValue = Array.get(flattened, i);
            Object targetValue = ImplicitConversions.convert(sourceValue, targetType);
            Array.set(transformed, i, targetValue);
        }
        return ArrayUtil.unflatten((Object)transformed, (int[])dimensions);
    }

    private static boolean equals(Object lhs, Object rhs) {
        if (lhs == null || rhs == null) {
            return Objects.equals(lhs, rhs);
        }
        if (lhs.getClass().isArray()) {
            return Objects.deepEquals(lhs, rhs);
        }
        return Objects.equals(lhs, rhs);
    }

    private static BuiltinDataType getType(@Nonnull Object o) {
        if (o.getClass().isArray()) {
            return BuiltinDataType.fromBackingClass((Class)ArrayUtil.getType((Object)o));
        }
        return BuiltinDataType.fromBackingClass(o.getClass());
    }
}

