/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.events.conversions;

import java.nio.ByteBuffer;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.BuiltinDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;

final class GuidConversions {
    private GuidConversions() {
    }

    @Nonnull
    static ByteString guidToByteString(@Nonnull UUID uuid) {
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        return ByteString.of((byte[])bb.array());
    }

    @Nonnull
    static String guidToString(@Nonnull UUID uuid) {
        return uuid.toString();
    }

    @Nullable
    static Object convert(@Nonnull Object o, BuiltinDataType targetType, boolean implicit) {
        if (o instanceof UUID) {
            UUID uuid = (UUID)o;
            return implicit ? GuidConversions.implicitConversion(uuid, targetType) : GuidConversions.explicitConversion(uuid, targetType);
        }
        return null;
    }

    @Nullable
    static Object explicitConversion(@Nonnull UUID uuid, BuiltinDataType targetType) {
        switch (targetType) {
            case ByteString: {
                return GuidConversions.guidToByteString(uuid);
            }
            case String: {
                return GuidConversions.guidToString(uuid);
            }
        }
        return GuidConversions.implicitConversion(uuid, targetType);
    }

    @Nullable
    static Object implicitConversion(@Nonnull UUID uuid, BuiltinDataType targetType) {
        return null;
    }
}

