/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.milo.client;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.milo.client.MiloClientComponent;
import org.apache.camel.component.milo.client.MiloClientConfiguration;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;

public class MiloClientComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private static final Map<String, Object> ALL_OPTIONS;

    private MiloClientConfiguration getOrCreateConfiguration(MiloClientComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new MiloClientConfiguration());
        }
        return target.getConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        MiloClientComponent target = (MiloClientComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "allowedsecuritypolicies": 
            case "allowedSecurityPolicies": {
                this.getOrCreateConfiguration(target).setAllowedSecurityPolicies((String)MiloClientComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "applicationname": 
            case "applicationName": {
                this.getOrCreateConfiguration(target).setApplicationName((String)MiloClientComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "applicationuri": 
            case "applicationUri": {
                this.getOrCreateConfiguration(target).setApplicationUri((String)MiloClientComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                target.setBasicPropertyBinding((Boolean)MiloClientComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler((Boolean)MiloClientComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "channellifetime": 
            case "channelLifetime": {
                this.getOrCreateConfiguration(target).setChannelLifetime((Long)MiloClientComponentConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "clientid": 
            case "clientId": {
                this.getOrCreateConfiguration(target).setClientId((String)MiloClientComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "configuration": {
                target.setConfiguration((MiloClientConfiguration)MiloClientComponentConfigurer.property((CamelContext)camelContext, MiloClientConfiguration.class, (Object)value));
                return true;
            }
            case "discoveryendpointsuffix": 
            case "discoveryEndpointSuffix": {
                this.getOrCreateConfiguration(target).setDiscoveryEndpointSuffix((String)MiloClientComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "discoveryendpointuri": 
            case "discoveryEndpointUri": {
                this.getOrCreateConfiguration(target).setDiscoveryEndpointUri((String)MiloClientComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "keyalias": 
            case "keyAlias": {
                this.getOrCreateConfiguration(target).setKeyAlias((String)MiloClientComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "keypassword": 
            case "keyPassword": {
                this.getOrCreateConfiguration(target).setKeyPassword((String)MiloClientComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "keystorepassword": 
            case "keyStorePassword": {
                this.getOrCreateConfiguration(target).setKeyStorePassword((String)MiloClientComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "keystoretype": 
            case "keyStoreType": {
                this.getOrCreateConfiguration(target).setKeyStoreType((String)MiloClientComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "keystoreurl": 
            case "keyStoreUrl": {
                this.getOrCreateConfiguration(target).setKeyStoreUrl((String)MiloClientComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)MiloClientComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "maxpendingpublishrequests": 
            case "maxPendingPublishRequests": {
                this.getOrCreateConfiguration(target).setMaxPendingPublishRequests((Long)MiloClientComponentConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "maxresponsemessagesize": 
            case "maxResponseMessageSize": {
                this.getOrCreateConfiguration(target).setMaxResponseMessageSize((Long)MiloClientComponentConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "overridehost": 
            case "overrideHost": {
                this.getOrCreateConfiguration(target).setOverrideHost((Boolean)MiloClientComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "producturi": 
            case "productUri": {
                this.getOrCreateConfiguration(target).setProductUri((String)MiloClientComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "requesttimeout": 
            case "requestTimeout": {
                this.getOrCreateConfiguration(target).setRequestTimeout((Long)MiloClientComponentConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "requestedpublishinginterval": 
            case "requestedPublishingInterval": {
                this.getOrCreateConfiguration(target).setRequestedPublishingInterval((Double)MiloClientComponentConfigurer.property((CamelContext)camelContext, Double.class, (Object)value));
                return true;
            }
            case "sessionname": 
            case "sessionName": {
                this.getOrCreateConfiguration(target).setSessionName((String)MiloClientComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sessiontimeout": 
            case "sessionTimeout": {
                this.getOrCreateConfiguration(target).setSessionTimeout((Long)MiloClientComponentConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        return ALL_OPTIONS;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        MiloClientComponent target = (MiloClientComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "allowedsecuritypolicies": 
            case "allowedSecurityPolicies": {
                return this.getOrCreateConfiguration(target).getAllowedSecurityPolicies();
            }
            case "applicationname": 
            case "applicationName": {
                return this.getOrCreateConfiguration(target).getApplicationName();
            }
            case "applicationuri": 
            case "applicationUri": {
                return this.getOrCreateConfiguration(target).getApplicationUri();
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                return target.isBasicPropertyBinding();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "channellifetime": 
            case "channelLifetime": {
                return this.getOrCreateConfiguration(target).getChannelLifetime();
            }
            case "clientid": 
            case "clientId": {
                return this.getOrCreateConfiguration(target).getClientId();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "discoveryendpointsuffix": 
            case "discoveryEndpointSuffix": {
                return this.getOrCreateConfiguration(target).getDiscoveryEndpointSuffix();
            }
            case "discoveryendpointuri": 
            case "discoveryEndpointUri": {
                return this.getOrCreateConfiguration(target).getDiscoveryEndpointUri();
            }
            case "keyalias": 
            case "keyAlias": {
                return this.getOrCreateConfiguration(target).getKeyAlias();
            }
            case "keypassword": 
            case "keyPassword": {
                return this.getOrCreateConfiguration(target).getKeyPassword();
            }
            case "keystorepassword": 
            case "keyStorePassword": {
                return this.getOrCreateConfiguration(target).getKeyStorePassword();
            }
            case "keystoretype": 
            case "keyStoreType": {
                return this.getOrCreateConfiguration(target).getKeyStoreType();
            }
            case "keystoreurl": 
            case "keyStoreUrl": {
                return this.getOrCreateConfiguration(target).getKeyStoreUrl();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "maxpendingpublishrequests": 
            case "maxPendingPublishRequests": {
                return this.getOrCreateConfiguration(target).getMaxPendingPublishRequests();
            }
            case "maxresponsemessagesize": 
            case "maxResponseMessageSize": {
                return this.getOrCreateConfiguration(target).getMaxResponseMessageSize();
            }
            case "overridehost": 
            case "overrideHost": {
                return this.getOrCreateConfiguration(target).isOverrideHost();
            }
            case "producturi": 
            case "productUri": {
                return this.getOrCreateConfiguration(target).getProductUri();
            }
            case "requesttimeout": 
            case "requestTimeout": {
                return this.getOrCreateConfiguration(target).getRequestTimeout();
            }
            case "requestedpublishinginterval": 
            case "requestedPublishingInterval": {
                return this.getOrCreateConfiguration(target).getRequestedPublishingInterval();
            }
            case "sessionname": 
            case "sessionName": {
                return this.getOrCreateConfiguration(target).getSessionName();
            }
            case "sessiontimeout": 
            case "sessionTimeout": {
                return this.getOrCreateConfiguration(target).getSessionTimeout();
            }
        }
        return null;
    }

    static {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("clientId", String.class);
        map.put("configuration", MiloClientConfiguration.class);
        map.put("discoveryEndpointSuffix", String.class);
        map.put("discoveryEndpointUri", String.class);
        map.put("bridgeErrorHandler", Boolean.TYPE);
        map.put("lazyStartProducer", Boolean.TYPE);
        map.put("basicPropertyBinding", Boolean.TYPE);
        map.put("allowedSecurityPolicies", String.class);
        map.put("applicationName", String.class);
        map.put("applicationUri", String.class);
        map.put("channelLifetime", Long.class);
        map.put("keyAlias", String.class);
        map.put("keyPassword", String.class);
        map.put("keyStorePassword", String.class);
        map.put("keyStoreType", String.class);
        map.put("keyStoreUrl", String.class);
        map.put("maxPendingPublishRequests", Long.class);
        map.put("maxResponseMessageSize", Long.class);
        map.put("overrideHost", Boolean.TYPE);
        map.put("productUri", String.class);
        map.put("requestedPublishingInterval", Double.class);
        map.put("requestTimeout", Long.class);
        map.put("sessionName", String.class);
        map.put("sessionTimeout", Long.class);
        ALL_OPTIONS = map;
    }
}

