/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.milo.server.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.component.milo.server.internal.CamelServerItem;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.api.DataItem;
import org.eclipse.milo.opcua.sdk.server.api.ManagedNamespace;
import org.eclipse.milo.opcua.sdk.server.api.MonitoredItem;
import org.eclipse.milo.opcua.sdk.server.api.nodes.Node;
import org.eclipse.milo.opcua.sdk.server.api.services.AttributeServices;
import org.eclipse.milo.opcua.sdk.server.nodes.UaFolderNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNodeContext;
import org.eclipse.milo.opcua.sdk.server.nodes.UaObjectNode;
import org.eclipse.milo.opcua.sdk.server.util.SubscriptionModel;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;

public class CamelNamespace
extends ManagedNamespace {
    private final SubscriptionModel subscriptionModel;
    private UaObjectNode itemsObject;
    private UaFolderNode folder;
    private final Map<String, CamelServerItem> itemMap = new HashMap<String, CamelServerItem>();

    public CamelNamespace(String namespaceUri, OpcUaServer server) {
        super(server, namespaceUri);
        this.subscriptionModel = new SubscriptionModel(server, (AttributeServices)this);
    }

    protected void onStartup() {
        super.onStartup();
        NodeId nodeId = this.newNodeId("camel");
        QualifiedName name = this.newQualifiedName("camel");
        LocalizedText displayName = LocalizedText.english((String)"Camel");
        this.folder = new UaFolderNode(this.getNodeContext(), nodeId, name, displayName);
        this.getNodeManager().addNode((Node)this.folder);
        NodeId nodeId2 = this.newNodeId("items");
        QualifiedName name2 = this.newQualifiedName("items");
        LocalizedText displayName2 = LocalizedText.english((String)"Items");
        this.itemsObject = UaObjectNode.builder((UaNodeContext)this.getNodeContext()).setNodeId(nodeId2).setBrowseName(name2).setDisplayName(displayName2).setTypeDefinition(Identifiers.FolderType).build();
        this.folder.addComponent((UaNode)this.itemsObject);
        this.getNodeManager().addNode((Node)this.itemsObject);
        this.folder.addReference(new Reference(this.folder.getNodeId(), Identifiers.Organizes, Identifiers.ObjectsFolder.expanded(), false));
        this.itemsObject.addReference(new Reference(nodeId, Identifiers.HasComponent, Identifiers.ObjectNode.expanded(), Reference.Direction.INVERSE));
    }

    public void onDataItemsCreated(List<DataItem> dataItems) {
        this.subscriptionModel.onDataItemsCreated(dataItems);
    }

    public void onDataItemsModified(List<DataItem> dataItems) {
        this.subscriptionModel.onDataItemsModified(dataItems);
    }

    public void onDataItemsDeleted(List<DataItem> dataItems) {
        this.subscriptionModel.onDataItemsDeleted(dataItems);
    }

    public void onMonitoringModeChanged(List<MonitoredItem> monitoredItems) {
        this.subscriptionModel.onMonitoringModeChanged(monitoredItems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CamelServerItem getOrAddItem(String itemId) {
        CamelNamespace camelNamespace = this;
        synchronized (camelNamespace) {
            CamelServerItem item = this.itemMap.get(itemId);
            if (item == null) {
                item = new CamelServerItem(itemId, this.getNodeContext(), this.getNamespaceIndex(), this.itemsObject);
                this.itemMap.put(itemId, item);
            }
            return item;
        }
    }
}

