/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.milo.client;

import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.milo.client.MiloClientConnection;
import org.apache.camel.component.milo.client.MiloClientEndpoint;
import org.apache.camel.support.DefaultAsyncProducer;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;

public class MiloClientProducer
extends DefaultAsyncProducer {
    private static final String HEADER_NODE_IDS = "CamelMiloNodeIds";
    private MiloClientConnection connection;
    private final ExpandedNodeId nodeId;
    private final ExpandedNodeId methodId;
    private final boolean defaultAwaitWrites;

    public MiloClientProducer(MiloClientEndpoint endpoint, boolean defaultAwaitWrites) {
        super((Endpoint)endpoint);
        this.defaultAwaitWrites = defaultAwaitWrites;
        this.nodeId = endpoint.getNodeId();
        this.methodId = endpoint.getMethodId();
    }

    public MiloClientEndpoint getEndpoint() {
        return (MiloClientEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.connection = this.getEndpoint().createConnection();
    }

    protected void doStop() throws Exception {
        if (null != this.connection) {
            this.getEndpoint().releaseConnection(this.connection);
        }
        super.doStop();
    }

    public boolean process(Exchange exchange, AsyncCallback async) {
        CompletionStage<Object> future;
        Message msg = exchange.getIn();
        Object value = msg.getBody();
        if (msg.getHeaders().containsKey(HEADER_NODE_IDS)) {
            List nodeIds = (List)msg.getHeader(HEADER_NODE_IDS, List.class);
            List<ExpandedNodeId> expandedNodeIds = nodeIds.stream().map(String.class::cast).map(ExpandedNodeId::parse).collect(Collectors.toList());
            future = this.connection.readValues(expandedNodeIds).thenApply(nodes -> {
                exchange.getIn().setBody(nodes);
                return nodes;
            });
        } else {
            future = this.methodId == null ? this.connection.writeValue(this.nodeId, value) : this.connection.call(this.nodeId, this.methodId, value);
        }
        Boolean await = (Boolean)msg.getHeader("await", (Object)this.defaultAwaitWrites, Boolean.class);
        if (Boolean.TRUE.equals(await)) {
            future.whenComplete((v, ex) -> async.done(false));
            return false;
        }
        return true;
    }
}

