/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.milo.client;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class MiloClientEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":endpointUri";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "milo-client".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "endpointUri", null, true, copy);
        uri = this.buildQueryParameters(uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(33);
        props.add("productUri");
        props.add("monitorFilterType");
        props.add("keyAlias");
        props.add("channelLifetime");
        props.add("discoveryEndpointSuffix");
        props.add("defaultAwaitWrites");
        props.add("dataChangeFilterDeadbandValue");
        props.add("samplingInterval");
        props.add("keyStoreUrl");
        props.add("maxPendingPublishRequests");
        props.add("bridgeErrorHandler");
        props.add("keyPassword");
        props.add("endpointUri");
        props.add("applicationName");
        props.add("requestTimeout");
        props.add("keyStoreType");
        props.add("maxResponseMessageSize");
        props.add("clientId");
        props.add("method");
        props.add("keyStorePassword");
        props.add("dataChangeFilterTrigger");
        props.add("sessionName");
        props.add("exchangePattern");
        props.add("dataChangeFilterDeadbandType");
        props.add("node");
        props.add("lazyStartProducer");
        props.add("overrideHost");
        props.add("sessionTimeout");
        props.add("discoveryEndpointUri");
        props.add("applicationUri");
        props.add("allowedSecurityPolicies");
        props.add("exceptionHandler");
        props.add("requestedPublishingInterval");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(2);
        secretProps.add("keyStorePassword");
        secretProps.add("keyPassword");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
    }
}

