/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.milo.client;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.milo.Messages;
import org.apache.camel.component.milo.client.MiloClientConnection;
import org.apache.camel.component.milo.client.MiloClientEndpoint;
import org.apache.camel.support.DefaultConsumer;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiloClientConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(MiloClientConsumer.class);
    private MiloClientConnection connection;
    private MiloClientConnection.MonitorHandle handle;
    private ExpandedNodeId node;
    private Double samplingInterval;

    public MiloClientConsumer(MiloClientEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.node = endpoint.getNodeId();
        this.samplingInterval = endpoint.getSamplingInterval();
    }

    public MiloClientEndpoint getEndpoint() {
        return (MiloClientEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.connection = this.getEndpoint().createConnection();
        this.handle = this.connection.monitorValue(this.node, this.samplingInterval, this::handleValueUpdate);
    }

    protected void doStop() throws Exception {
        if (this.handle != null) {
            this.handle.unregister();
            this.handle = null;
        }
        if (this.connection != null) {
            this.getEndpoint().releaseConnection(this.connection);
        }
        super.doStop();
    }

    private void handleValueUpdate(DataValue value) {
        LOG.debug("Handle item update - {} = {}", (Object)this.node, (Object)value);
        Exchange exchange = this.createExchange(true);
        try {
            this.mapToMessage(value, exchange.getMessage());
            this.getProcessor().process(exchange);
        }
        catch (Exception e) {
            this.getExceptionHandler().handleException("Error processing exchange", (Throwable)e);
        }
    }

    private void mapToMessage(DataValue value, Message message) {
        if (value != null) {
            Messages.fillFromDataValue(value, message);
        }
    }
}

