/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.ApplicationDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.ServiceCounterDataType;

public class SessionDiagnosticsDataType
implements UaStructure {
    public static final NodeId TypeId = Identifiers.SessionDiagnosticsDataType;
    public static final NodeId BinaryEncodingId = Identifiers.SessionDiagnosticsDataType_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.SessionDiagnosticsDataType_Encoding_DefaultXml;
    protected final NodeId sessionId;
    protected final String sessionName;
    protected final ApplicationDescription clientDescription;
    protected final String serverUri;
    protected final String endpointUrl;
    protected final String[] localeIds;
    protected final Double actualSessionTimeout;
    protected final UInteger maxResponseMessageSize;
    protected final DateTime clientConnectionTime;
    protected final DateTime clientLastContactTime;
    protected final UInteger currentSubscriptionsCount;
    protected final UInteger currentMonitoredItemsCount;
    protected final UInteger currentPublishRequestsInQueue;
    protected final ServiceCounterDataType totalRequestCount;
    protected final UInteger unauthorizedRequestCount;
    protected final ServiceCounterDataType readCount;
    protected final ServiceCounterDataType historyReadCount;
    protected final ServiceCounterDataType writeCount;
    protected final ServiceCounterDataType historyUpdateCount;
    protected final ServiceCounterDataType callCount;
    protected final ServiceCounterDataType createMonitoredItemsCount;
    protected final ServiceCounterDataType modifyMonitoredItemsCount;
    protected final ServiceCounterDataType setMonitoringModeCount;
    protected final ServiceCounterDataType setTriggeringCount;
    protected final ServiceCounterDataType deleteMonitoredItemsCount;
    protected final ServiceCounterDataType createSubscriptionCount;
    protected final ServiceCounterDataType modifySubscriptionCount;
    protected final ServiceCounterDataType setPublishingModeCount;
    protected final ServiceCounterDataType publishCount;
    protected final ServiceCounterDataType republishCount;
    protected final ServiceCounterDataType transferSubscriptionsCount;
    protected final ServiceCounterDataType deleteSubscriptionsCount;
    protected final ServiceCounterDataType addNodesCount;
    protected final ServiceCounterDataType addReferencesCount;
    protected final ServiceCounterDataType deleteNodesCount;
    protected final ServiceCounterDataType deleteReferencesCount;
    protected final ServiceCounterDataType browseCount;
    protected final ServiceCounterDataType browseNextCount;
    protected final ServiceCounterDataType translateBrowsePathsToNodeIdsCount;
    protected final ServiceCounterDataType queryFirstCount;
    protected final ServiceCounterDataType queryNextCount;
    protected final ServiceCounterDataType registerNodesCount;
    protected final ServiceCounterDataType unregisterNodesCount;

    public SessionDiagnosticsDataType() {
        this.sessionId = null;
        this.sessionName = null;
        this.clientDescription = null;
        this.serverUri = null;
        this.endpointUrl = null;
        this.localeIds = null;
        this.actualSessionTimeout = null;
        this.maxResponseMessageSize = null;
        this.clientConnectionTime = null;
        this.clientLastContactTime = null;
        this.currentSubscriptionsCount = null;
        this.currentMonitoredItemsCount = null;
        this.currentPublishRequestsInQueue = null;
        this.totalRequestCount = null;
        this.unauthorizedRequestCount = null;
        this.readCount = null;
        this.historyReadCount = null;
        this.writeCount = null;
        this.historyUpdateCount = null;
        this.callCount = null;
        this.createMonitoredItemsCount = null;
        this.modifyMonitoredItemsCount = null;
        this.setMonitoringModeCount = null;
        this.setTriggeringCount = null;
        this.deleteMonitoredItemsCount = null;
        this.createSubscriptionCount = null;
        this.modifySubscriptionCount = null;
        this.setPublishingModeCount = null;
        this.publishCount = null;
        this.republishCount = null;
        this.transferSubscriptionsCount = null;
        this.deleteSubscriptionsCount = null;
        this.addNodesCount = null;
        this.addReferencesCount = null;
        this.deleteNodesCount = null;
        this.deleteReferencesCount = null;
        this.browseCount = null;
        this.browseNextCount = null;
        this.translateBrowsePathsToNodeIdsCount = null;
        this.queryFirstCount = null;
        this.queryNextCount = null;
        this.registerNodesCount = null;
        this.unregisterNodesCount = null;
    }

    public SessionDiagnosticsDataType(NodeId sessionId, String sessionName, ApplicationDescription clientDescription, String serverUri, String endpointUrl, String[] localeIds, Double actualSessionTimeout, UInteger maxResponseMessageSize, DateTime clientConnectionTime, DateTime clientLastContactTime, UInteger currentSubscriptionsCount, UInteger currentMonitoredItemsCount, UInteger currentPublishRequestsInQueue, ServiceCounterDataType totalRequestCount, UInteger unauthorizedRequestCount, ServiceCounterDataType readCount, ServiceCounterDataType historyReadCount, ServiceCounterDataType writeCount, ServiceCounterDataType historyUpdateCount, ServiceCounterDataType callCount, ServiceCounterDataType createMonitoredItemsCount, ServiceCounterDataType modifyMonitoredItemsCount, ServiceCounterDataType setMonitoringModeCount, ServiceCounterDataType setTriggeringCount, ServiceCounterDataType deleteMonitoredItemsCount, ServiceCounterDataType createSubscriptionCount, ServiceCounterDataType modifySubscriptionCount, ServiceCounterDataType setPublishingModeCount, ServiceCounterDataType publishCount, ServiceCounterDataType republishCount, ServiceCounterDataType transferSubscriptionsCount, ServiceCounterDataType deleteSubscriptionsCount, ServiceCounterDataType addNodesCount, ServiceCounterDataType addReferencesCount, ServiceCounterDataType deleteNodesCount, ServiceCounterDataType deleteReferencesCount, ServiceCounterDataType browseCount, ServiceCounterDataType browseNextCount, ServiceCounterDataType translateBrowsePathsToNodeIdsCount, ServiceCounterDataType queryFirstCount, ServiceCounterDataType queryNextCount, ServiceCounterDataType registerNodesCount, ServiceCounterDataType unregisterNodesCount) {
        this.sessionId = sessionId;
        this.sessionName = sessionName;
        this.clientDescription = clientDescription;
        this.serverUri = serverUri;
        this.endpointUrl = endpointUrl;
        this.localeIds = localeIds;
        this.actualSessionTimeout = actualSessionTimeout;
        this.maxResponseMessageSize = maxResponseMessageSize;
        this.clientConnectionTime = clientConnectionTime;
        this.clientLastContactTime = clientLastContactTime;
        this.currentSubscriptionsCount = currentSubscriptionsCount;
        this.currentMonitoredItemsCount = currentMonitoredItemsCount;
        this.currentPublishRequestsInQueue = currentPublishRequestsInQueue;
        this.totalRequestCount = totalRequestCount;
        this.unauthorizedRequestCount = unauthorizedRequestCount;
        this.readCount = readCount;
        this.historyReadCount = historyReadCount;
        this.writeCount = writeCount;
        this.historyUpdateCount = historyUpdateCount;
        this.callCount = callCount;
        this.createMonitoredItemsCount = createMonitoredItemsCount;
        this.modifyMonitoredItemsCount = modifyMonitoredItemsCount;
        this.setMonitoringModeCount = setMonitoringModeCount;
        this.setTriggeringCount = setTriggeringCount;
        this.deleteMonitoredItemsCount = deleteMonitoredItemsCount;
        this.createSubscriptionCount = createSubscriptionCount;
        this.modifySubscriptionCount = modifySubscriptionCount;
        this.setPublishingModeCount = setPublishingModeCount;
        this.publishCount = publishCount;
        this.republishCount = republishCount;
        this.transferSubscriptionsCount = transferSubscriptionsCount;
        this.deleteSubscriptionsCount = deleteSubscriptionsCount;
        this.addNodesCount = addNodesCount;
        this.addReferencesCount = addReferencesCount;
        this.deleteNodesCount = deleteNodesCount;
        this.deleteReferencesCount = deleteReferencesCount;
        this.browseCount = browseCount;
        this.browseNextCount = browseNextCount;
        this.translateBrowsePathsToNodeIdsCount = translateBrowsePathsToNodeIdsCount;
        this.queryFirstCount = queryFirstCount;
        this.queryNextCount = queryNextCount;
        this.registerNodesCount = registerNodesCount;
        this.unregisterNodesCount = unregisterNodesCount;
    }

    public NodeId getSessionId() {
        return this.sessionId;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public ApplicationDescription getClientDescription() {
        return this.clientDescription;
    }

    public String getServerUri() {
        return this.serverUri;
    }

    public String getEndpointUrl() {
        return this.endpointUrl;
    }

    @Nullable
    public String[] getLocaleIds() {
        return this.localeIds;
    }

    public Double getActualSessionTimeout() {
        return this.actualSessionTimeout;
    }

    public UInteger getMaxResponseMessageSize() {
        return this.maxResponseMessageSize;
    }

    public DateTime getClientConnectionTime() {
        return this.clientConnectionTime;
    }

    public DateTime getClientLastContactTime() {
        return this.clientLastContactTime;
    }

    public UInteger getCurrentSubscriptionsCount() {
        return this.currentSubscriptionsCount;
    }

    public UInteger getCurrentMonitoredItemsCount() {
        return this.currentMonitoredItemsCount;
    }

    public UInteger getCurrentPublishRequestsInQueue() {
        return this.currentPublishRequestsInQueue;
    }

    public ServiceCounterDataType getTotalRequestCount() {
        return this.totalRequestCount;
    }

    public UInteger getUnauthorizedRequestCount() {
        return this.unauthorizedRequestCount;
    }

    public ServiceCounterDataType getReadCount() {
        return this.readCount;
    }

    public ServiceCounterDataType getHistoryReadCount() {
        return this.historyReadCount;
    }

    public ServiceCounterDataType getWriteCount() {
        return this.writeCount;
    }

    public ServiceCounterDataType getHistoryUpdateCount() {
        return this.historyUpdateCount;
    }

    public ServiceCounterDataType getCallCount() {
        return this.callCount;
    }

    public ServiceCounterDataType getCreateMonitoredItemsCount() {
        return this.createMonitoredItemsCount;
    }

    public ServiceCounterDataType getModifyMonitoredItemsCount() {
        return this.modifyMonitoredItemsCount;
    }

    public ServiceCounterDataType getSetMonitoringModeCount() {
        return this.setMonitoringModeCount;
    }

    public ServiceCounterDataType getSetTriggeringCount() {
        return this.setTriggeringCount;
    }

    public ServiceCounterDataType getDeleteMonitoredItemsCount() {
        return this.deleteMonitoredItemsCount;
    }

    public ServiceCounterDataType getCreateSubscriptionCount() {
        return this.createSubscriptionCount;
    }

    public ServiceCounterDataType getModifySubscriptionCount() {
        return this.modifySubscriptionCount;
    }

    public ServiceCounterDataType getSetPublishingModeCount() {
        return this.setPublishingModeCount;
    }

    public ServiceCounterDataType getPublishCount() {
        return this.publishCount;
    }

    public ServiceCounterDataType getRepublishCount() {
        return this.republishCount;
    }

    public ServiceCounterDataType getTransferSubscriptionsCount() {
        return this.transferSubscriptionsCount;
    }

    public ServiceCounterDataType getDeleteSubscriptionsCount() {
        return this.deleteSubscriptionsCount;
    }

    public ServiceCounterDataType getAddNodesCount() {
        return this.addNodesCount;
    }

    public ServiceCounterDataType getAddReferencesCount() {
        return this.addReferencesCount;
    }

    public ServiceCounterDataType getDeleteNodesCount() {
        return this.deleteNodesCount;
    }

    public ServiceCounterDataType getDeleteReferencesCount() {
        return this.deleteReferencesCount;
    }

    public ServiceCounterDataType getBrowseCount() {
        return this.browseCount;
    }

    public ServiceCounterDataType getBrowseNextCount() {
        return this.browseNextCount;
    }

    public ServiceCounterDataType getTranslateBrowsePathsToNodeIdsCount() {
        return this.translateBrowsePathsToNodeIdsCount;
    }

    public ServiceCounterDataType getQueryFirstCount() {
        return this.queryFirstCount;
    }

    public ServiceCounterDataType getQueryNextCount() {
        return this.queryNextCount;
    }

    public ServiceCounterDataType getRegisterNodesCount() {
        return this.registerNodesCount;
    }

    public ServiceCounterDataType getUnregisterNodesCount() {
        return this.unregisterNodesCount;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("SessionId", (Object)this.sessionId).add("SessionName", (Object)this.sessionName).add("ClientDescription", (Object)this.clientDescription).add("ServerUri", (Object)this.serverUri).add("EndpointUrl", (Object)this.endpointUrl).add("LocaleIds", (Object)this.localeIds).add("ActualSessionTimeout", (Object)this.actualSessionTimeout).add("MaxResponseMessageSize", (Object)this.maxResponseMessageSize).add("ClientConnectionTime", (Object)this.clientConnectionTime).add("ClientLastContactTime", (Object)this.clientLastContactTime).add("CurrentSubscriptionsCount", (Object)this.currentSubscriptionsCount).add("CurrentMonitoredItemsCount", (Object)this.currentMonitoredItemsCount).add("CurrentPublishRequestsInQueue", (Object)this.currentPublishRequestsInQueue).add("TotalRequestCount", (Object)this.totalRequestCount).add("UnauthorizedRequestCount", (Object)this.unauthorizedRequestCount).add("ReadCount", (Object)this.readCount).add("HistoryReadCount", (Object)this.historyReadCount).add("WriteCount", (Object)this.writeCount).add("HistoryUpdateCount", (Object)this.historyUpdateCount).add("CallCount", (Object)this.callCount).add("CreateMonitoredItemsCount", (Object)this.createMonitoredItemsCount).add("ModifyMonitoredItemsCount", (Object)this.modifyMonitoredItemsCount).add("SetMonitoringModeCount", (Object)this.setMonitoringModeCount).add("SetTriggeringCount", (Object)this.setTriggeringCount).add("DeleteMonitoredItemsCount", (Object)this.deleteMonitoredItemsCount).add("CreateSubscriptionCount", (Object)this.createSubscriptionCount).add("ModifySubscriptionCount", (Object)this.modifySubscriptionCount).add("SetPublishingModeCount", (Object)this.setPublishingModeCount).add("PublishCount", (Object)this.publishCount).add("RepublishCount", (Object)this.republishCount).add("TransferSubscriptionsCount", (Object)this.transferSubscriptionsCount).add("DeleteSubscriptionsCount", (Object)this.deleteSubscriptionsCount).add("AddNodesCount", (Object)this.addNodesCount).add("AddReferencesCount", (Object)this.addReferencesCount).add("DeleteNodesCount", (Object)this.deleteNodesCount).add("DeleteReferencesCount", (Object)this.deleteReferencesCount).add("BrowseCount", (Object)this.browseCount).add("BrowseNextCount", (Object)this.browseNextCount).add("TranslateBrowsePathsToNodeIdsCount", (Object)this.translateBrowsePathsToNodeIdsCount).add("QueryFirstCount", (Object)this.queryFirstCount).add("QueryNextCount", (Object)this.queryNextCount).add("RegisterNodesCount", (Object)this.registerNodesCount).add("UnregisterNodesCount", (Object)this.unregisterNodesCount).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<SessionDiagnosticsDataType> {
        @Override
        public Class<SessionDiagnosticsDataType> getType() {
            return SessionDiagnosticsDataType.class;
        }

        @Override
        public SessionDiagnosticsDataType decode(UaDecoder decoder) throws UaSerializationException {
            NodeId sessionId = decoder.readNodeId("SessionId");
            String sessionName = decoder.readString("SessionName");
            ApplicationDescription clientDescription = decoder.readBuiltinStruct("ClientDescription", ApplicationDescription.class);
            String serverUri = decoder.readString("ServerUri");
            String endpointUrl = decoder.readString("EndpointUrl");
            String[] localeIds = decoder.readArray("LocaleIds", decoder::readString, String.class);
            Double actualSessionTimeout = decoder.readDouble("ActualSessionTimeout");
            UInteger maxResponseMessageSize = decoder.readUInt32("MaxResponseMessageSize");
            DateTime clientConnectionTime = decoder.readDateTime("ClientConnectionTime");
            DateTime clientLastContactTime = decoder.readDateTime("ClientLastContactTime");
            UInteger currentSubscriptionsCount = decoder.readUInt32("CurrentSubscriptionsCount");
            UInteger currentMonitoredItemsCount = decoder.readUInt32("CurrentMonitoredItemsCount");
            UInteger currentPublishRequestsInQueue = decoder.readUInt32("CurrentPublishRequestsInQueue");
            ServiceCounterDataType totalRequestCount = decoder.readBuiltinStruct("TotalRequestCount", ServiceCounterDataType.class);
            UInteger unauthorizedRequestCount = decoder.readUInt32("UnauthorizedRequestCount");
            ServiceCounterDataType readCount = decoder.readBuiltinStruct("ReadCount", ServiceCounterDataType.class);
            ServiceCounterDataType historyReadCount = decoder.readBuiltinStruct("HistoryReadCount", ServiceCounterDataType.class);
            ServiceCounterDataType writeCount = decoder.readBuiltinStruct("WriteCount", ServiceCounterDataType.class);
            ServiceCounterDataType historyUpdateCount = decoder.readBuiltinStruct("HistoryUpdateCount", ServiceCounterDataType.class);
            ServiceCounterDataType callCount = decoder.readBuiltinStruct("CallCount", ServiceCounterDataType.class);
            ServiceCounterDataType createMonitoredItemsCount = decoder.readBuiltinStruct("CreateMonitoredItemsCount", ServiceCounterDataType.class);
            ServiceCounterDataType modifyMonitoredItemsCount = decoder.readBuiltinStruct("ModifyMonitoredItemsCount", ServiceCounterDataType.class);
            ServiceCounterDataType setMonitoringModeCount = decoder.readBuiltinStruct("SetMonitoringModeCount", ServiceCounterDataType.class);
            ServiceCounterDataType setTriggeringCount = decoder.readBuiltinStruct("SetTriggeringCount", ServiceCounterDataType.class);
            ServiceCounterDataType deleteMonitoredItemsCount = decoder.readBuiltinStruct("DeleteMonitoredItemsCount", ServiceCounterDataType.class);
            ServiceCounterDataType createSubscriptionCount = decoder.readBuiltinStruct("CreateSubscriptionCount", ServiceCounterDataType.class);
            ServiceCounterDataType modifySubscriptionCount = decoder.readBuiltinStruct("ModifySubscriptionCount", ServiceCounterDataType.class);
            ServiceCounterDataType setPublishingModeCount = decoder.readBuiltinStruct("SetPublishingModeCount", ServiceCounterDataType.class);
            ServiceCounterDataType publishCount = decoder.readBuiltinStruct("PublishCount", ServiceCounterDataType.class);
            ServiceCounterDataType republishCount = decoder.readBuiltinStruct("RepublishCount", ServiceCounterDataType.class);
            ServiceCounterDataType transferSubscriptionsCount = decoder.readBuiltinStruct("TransferSubscriptionsCount", ServiceCounterDataType.class);
            ServiceCounterDataType deleteSubscriptionsCount = decoder.readBuiltinStruct("DeleteSubscriptionsCount", ServiceCounterDataType.class);
            ServiceCounterDataType addNodesCount = decoder.readBuiltinStruct("AddNodesCount", ServiceCounterDataType.class);
            ServiceCounterDataType addReferencesCount = decoder.readBuiltinStruct("AddReferencesCount", ServiceCounterDataType.class);
            ServiceCounterDataType deleteNodesCount = decoder.readBuiltinStruct("DeleteNodesCount", ServiceCounterDataType.class);
            ServiceCounterDataType deleteReferencesCount = decoder.readBuiltinStruct("DeleteReferencesCount", ServiceCounterDataType.class);
            ServiceCounterDataType browseCount = decoder.readBuiltinStruct("BrowseCount", ServiceCounterDataType.class);
            ServiceCounterDataType browseNextCount = decoder.readBuiltinStruct("BrowseNextCount", ServiceCounterDataType.class);
            ServiceCounterDataType translateBrowsePathsToNodeIdsCount = decoder.readBuiltinStruct("TranslateBrowsePathsToNodeIdsCount", ServiceCounterDataType.class);
            ServiceCounterDataType queryFirstCount = decoder.readBuiltinStruct("QueryFirstCount", ServiceCounterDataType.class);
            ServiceCounterDataType queryNextCount = decoder.readBuiltinStruct("QueryNextCount", ServiceCounterDataType.class);
            ServiceCounterDataType registerNodesCount = decoder.readBuiltinStruct("RegisterNodesCount", ServiceCounterDataType.class);
            ServiceCounterDataType unregisterNodesCount = decoder.readBuiltinStruct("UnregisterNodesCount", ServiceCounterDataType.class);
            return new SessionDiagnosticsDataType(sessionId, sessionName, clientDescription, serverUri, endpointUrl, localeIds, actualSessionTimeout, maxResponseMessageSize, clientConnectionTime, clientLastContactTime, currentSubscriptionsCount, currentMonitoredItemsCount, currentPublishRequestsInQueue, totalRequestCount, unauthorizedRequestCount, readCount, historyReadCount, writeCount, historyUpdateCount, callCount, createMonitoredItemsCount, modifyMonitoredItemsCount, setMonitoringModeCount, setTriggeringCount, deleteMonitoredItemsCount, createSubscriptionCount, modifySubscriptionCount, setPublishingModeCount, publishCount, republishCount, transferSubscriptionsCount, deleteSubscriptionsCount, addNodesCount, addReferencesCount, deleteNodesCount, deleteReferencesCount, browseCount, browseNextCount, translateBrowsePathsToNodeIdsCount, queryFirstCount, queryNextCount, registerNodesCount, unregisterNodesCount);
        }

        @Override
        public void encode(SessionDiagnosticsDataType value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeNodeId("SessionId", value.sessionId);
            encoder.writeString("SessionName", value.sessionName);
            encoder.writeBuiltinStruct("ClientDescription", value.clientDescription, ApplicationDescription.class);
            encoder.writeString("ServerUri", value.serverUri);
            encoder.writeString("EndpointUrl", value.endpointUrl);
            encoder.writeArray("LocaleIds", value.localeIds, encoder::writeString);
            encoder.writeDouble("ActualSessionTimeout", value.actualSessionTimeout);
            encoder.writeUInt32("MaxResponseMessageSize", value.maxResponseMessageSize);
            encoder.writeDateTime("ClientConnectionTime", value.clientConnectionTime);
            encoder.writeDateTime("ClientLastContactTime", value.clientLastContactTime);
            encoder.writeUInt32("CurrentSubscriptionsCount", value.currentSubscriptionsCount);
            encoder.writeUInt32("CurrentMonitoredItemsCount", value.currentMonitoredItemsCount);
            encoder.writeUInt32("CurrentPublishRequestsInQueue", value.currentPublishRequestsInQueue);
            encoder.writeBuiltinStruct("TotalRequestCount", value.totalRequestCount, ServiceCounterDataType.class);
            encoder.writeUInt32("UnauthorizedRequestCount", value.unauthorizedRequestCount);
            encoder.writeBuiltinStruct("ReadCount", value.readCount, ServiceCounterDataType.class);
            encoder.writeBuiltinStruct("HistoryReadCount", value.historyReadCount, ServiceCounterDataType.class);
            encoder.writeBuiltinStruct("WriteCount", value.writeCount, ServiceCounterDataType.class);
            encoder.writeBuiltinStruct("HistoryUpdateCount", value.historyUpdateCount, ServiceCounterDataType.class);
            encoder.writeBuiltinStruct("CallCount", value.callCount, ServiceCounterDataType.class);
            encoder.writeBuiltinStruct("CreateMonitoredItemsCount", value.createMonitoredItemsCount, ServiceCounterDataType.class);
            encoder.writeBuiltinStruct("ModifyMonitoredItemsCount", value.modifyMonitoredItemsCount, ServiceCounterDataType.class);
            encoder.writeBuiltinStruct("SetMonitoringModeCount", value.setMonitoringModeCount, ServiceCounterDataType.class);
            encoder.writeBuiltinStruct("SetTriggeringCount", value.setTriggeringCount, ServiceCounterDataType.class);
            encoder.writeBuiltinStruct("DeleteMonitoredItemsCount", value.deleteMonitoredItemsCount, ServiceCounterDataType.class);
            encoder.writeBuiltinStruct("CreateSubscriptionCount", value.createSubscriptionCount, ServiceCounterDataType.class);
            encoder.writeBuiltinStruct("ModifySubscriptionCount", value.modifySubscriptionCount, ServiceCounterDataType.class);
            encoder.writeBuiltinStruct("SetPublishingModeCount", value.setPublishingModeCount, ServiceCounterDataType.class);
            encoder.writeBuiltinStruct("PublishCount", value.publishCount, ServiceCounterDataType.class);
            encoder.writeBuiltinStruct("RepublishCount", value.republishCount, ServiceCounterDataType.class);
            encoder.writeBuiltinStruct("TransferSubscriptionsCount", value.transferSubscriptionsCount, ServiceCounterDataType.class);
            encoder.writeBuiltinStruct("DeleteSubscriptionsCount", value.deleteSubscriptionsCount, ServiceCounterDataType.class);
            encoder.writeBuiltinStruct("AddNodesCount", value.addNodesCount, ServiceCounterDataType.class);
            encoder.writeBuiltinStruct("AddReferencesCount", value.addReferencesCount, ServiceCounterDataType.class);
            encoder.writeBuiltinStruct("DeleteNodesCount", value.deleteNodesCount, ServiceCounterDataType.class);
            encoder.writeBuiltinStruct("DeleteReferencesCount", value.deleteReferencesCount, ServiceCounterDataType.class);
            encoder.writeBuiltinStruct("BrowseCount", value.browseCount, ServiceCounterDataType.class);
            encoder.writeBuiltinStruct("BrowseNextCount", value.browseNextCount, ServiceCounterDataType.class);
            encoder.writeBuiltinStruct("TranslateBrowsePathsToNodeIdsCount", value.translateBrowsePathsToNodeIdsCount, ServiceCounterDataType.class);
            encoder.writeBuiltinStruct("QueryFirstCount", value.queryFirstCount, ServiceCounterDataType.class);
            encoder.writeBuiltinStruct("QueryNextCount", value.queryNextCount, ServiceCounterDataType.class);
            encoder.writeBuiltinStruct("RegisterNodesCount", value.registerNodesCount, ServiceCounterDataType.class);
            encoder.writeBuiltinStruct("UnregisterNodesCount", value.unregisterNodesCount, ServiceCounterDataType.class);
        }
    }
}

