/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.enumerated.ApplicationType;

public class RegisteredServer
implements UaStructure {
    public static final NodeId TypeId = Identifiers.RegisteredServer;
    public static final NodeId BinaryEncodingId = Identifiers.RegisteredServer_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.RegisteredServer_Encoding_DefaultXml;
    protected final String serverUri;
    protected final String productUri;
    protected final LocalizedText[] serverNames;
    protected final ApplicationType serverType;
    protected final String gatewayServerUri;
    protected final String[] discoveryUrls;
    protected final String semaphoreFilePath;
    protected final Boolean isOnline;

    public RegisteredServer() {
        this.serverUri = null;
        this.productUri = null;
        this.serverNames = null;
        this.serverType = null;
        this.gatewayServerUri = null;
        this.discoveryUrls = null;
        this.semaphoreFilePath = null;
        this.isOnline = null;
    }

    public RegisteredServer(String serverUri, String productUri, LocalizedText[] serverNames, ApplicationType serverType, String gatewayServerUri, String[] discoveryUrls, String semaphoreFilePath, Boolean isOnline) {
        this.serverUri = serverUri;
        this.productUri = productUri;
        this.serverNames = serverNames;
        this.serverType = serverType;
        this.gatewayServerUri = gatewayServerUri;
        this.discoveryUrls = discoveryUrls;
        this.semaphoreFilePath = semaphoreFilePath;
        this.isOnline = isOnline;
    }

    public String getServerUri() {
        return this.serverUri;
    }

    public String getProductUri() {
        return this.productUri;
    }

    @Nullable
    public LocalizedText[] getServerNames() {
        return this.serverNames;
    }

    public ApplicationType getServerType() {
        return this.serverType;
    }

    public String getGatewayServerUri() {
        return this.gatewayServerUri;
    }

    @Nullable
    public String[] getDiscoveryUrls() {
        return this.discoveryUrls;
    }

    public String getSemaphoreFilePath() {
        return this.semaphoreFilePath;
    }

    public Boolean getIsOnline() {
        return this.isOnline;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ServerUri", (Object)this.serverUri).add("ProductUri", (Object)this.productUri).add("ServerNames", (Object)this.serverNames).add("ServerType", (Object)this.serverType).add("GatewayServerUri", (Object)this.gatewayServerUri).add("DiscoveryUrls", (Object)this.discoveryUrls).add("SemaphoreFilePath", (Object)this.semaphoreFilePath).add("IsOnline", (Object)this.isOnline).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<RegisteredServer> {
        @Override
        public Class<RegisteredServer> getType() {
            return RegisteredServer.class;
        }

        @Override
        public RegisteredServer decode(UaDecoder decoder) throws UaSerializationException {
            String serverUri = decoder.readString("ServerUri");
            String productUri = decoder.readString("ProductUri");
            LocalizedText[] serverNames = decoder.readArray("ServerNames", decoder::readLocalizedText, LocalizedText.class);
            ApplicationType serverType = ApplicationType.from(decoder.readInt32("ServerType"));
            String gatewayServerUri = decoder.readString("GatewayServerUri");
            String[] discoveryUrls = decoder.readArray("DiscoveryUrls", decoder::readString, String.class);
            String semaphoreFilePath = decoder.readString("SemaphoreFilePath");
            Boolean isOnline = decoder.readBoolean("IsOnline");
            return new RegisteredServer(serverUri, productUri, serverNames, serverType, gatewayServerUri, discoveryUrls, semaphoreFilePath, isOnline);
        }

        @Override
        public void encode(RegisteredServer value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeString("ServerUri", value.serverUri);
            encoder.writeString("ProductUri", value.productUri);
            encoder.writeArray("ServerNames", value.serverNames, encoder::writeLocalizedText);
            encoder.writeInt32("ServerType", value.serverType != null ? value.serverType.getValue() : 0);
            encoder.writeString("GatewayServerUri", value.gatewayServerUri);
            encoder.writeArray("DiscoveryUrls", value.discoveryUrls, encoder::writeString);
            encoder.writeString("SemaphoreFilePath", value.semaphoreFilePath);
            encoder.writeBoolean("IsOnline", value.isOnline);
        }
    }
}

