/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.ApplicationDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;

public class CreateSessionRequest
implements UaRequestMessage {
    public static final NodeId TypeId = Identifiers.CreateSessionRequest;
    public static final NodeId BinaryEncodingId = Identifiers.CreateSessionRequest_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.CreateSessionRequest_Encoding_DefaultXml;
    protected final RequestHeader requestHeader;
    protected final ApplicationDescription clientDescription;
    protected final String serverUri;
    protected final String endpointUrl;
    protected final String sessionName;
    protected final ByteString clientNonce;
    protected final ByteString clientCertificate;
    protected final Double requestedSessionTimeout;
    protected final UInteger maxResponseMessageSize;

    public CreateSessionRequest() {
        this.requestHeader = null;
        this.clientDescription = null;
        this.serverUri = null;
        this.endpointUrl = null;
        this.sessionName = null;
        this.clientNonce = null;
        this.clientCertificate = null;
        this.requestedSessionTimeout = null;
        this.maxResponseMessageSize = null;
    }

    public CreateSessionRequest(RequestHeader requestHeader, ApplicationDescription clientDescription, String serverUri, String endpointUrl, String sessionName, ByteString clientNonce, ByteString clientCertificate, Double requestedSessionTimeout, UInteger maxResponseMessageSize) {
        this.requestHeader = requestHeader;
        this.clientDescription = clientDescription;
        this.serverUri = serverUri;
        this.endpointUrl = endpointUrl;
        this.sessionName = sessionName;
        this.clientNonce = clientNonce;
        this.clientCertificate = clientCertificate;
        this.requestedSessionTimeout = requestedSessionTimeout;
        this.maxResponseMessageSize = maxResponseMessageSize;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public ApplicationDescription getClientDescription() {
        return this.clientDescription;
    }

    public String getServerUri() {
        return this.serverUri;
    }

    public String getEndpointUrl() {
        return this.endpointUrl;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public ByteString getClientNonce() {
        return this.clientNonce;
    }

    public ByteString getClientCertificate() {
        return this.clientCertificate;
    }

    public Double getRequestedSessionTimeout() {
        return this.requestedSessionTimeout;
    }

    public UInteger getMaxResponseMessageSize() {
        return this.maxResponseMessageSize;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("RequestHeader", (Object)this.requestHeader).add("ClientDescription", (Object)this.clientDescription).add("ServerUri", (Object)this.serverUri).add("EndpointUrl", (Object)this.endpointUrl).add("SessionName", (Object)this.sessionName).add("ClientNonce", (Object)this.clientNonce).add("ClientCertificate", (Object)this.clientCertificate).add("RequestedSessionTimeout", (Object)this.requestedSessionTimeout).add("MaxResponseMessageSize", (Object)this.maxResponseMessageSize).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<CreateSessionRequest> {
        @Override
        public Class<CreateSessionRequest> getType() {
            return CreateSessionRequest.class;
        }

        @Override
        public CreateSessionRequest decode(UaDecoder decoder) throws UaSerializationException {
            RequestHeader requestHeader = decoder.readBuiltinStruct("RequestHeader", RequestHeader.class);
            ApplicationDescription clientDescription = decoder.readBuiltinStruct("ClientDescription", ApplicationDescription.class);
            String serverUri = decoder.readString("ServerUri");
            String endpointUrl = decoder.readString("EndpointUrl");
            String sessionName = decoder.readString("SessionName");
            ByteString clientNonce = decoder.readByteString("ClientNonce");
            ByteString clientCertificate = decoder.readByteString("ClientCertificate");
            Double requestedSessionTimeout = decoder.readDouble("RequestedSessionTimeout");
            UInteger maxResponseMessageSize = decoder.readUInt32("MaxResponseMessageSize");
            return new CreateSessionRequest(requestHeader, clientDescription, serverUri, endpointUrl, sessionName, clientNonce, clientCertificate, requestedSessionTimeout, maxResponseMessageSize);
        }

        @Override
        public void encode(CreateSessionRequest value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeBuiltinStruct("RequestHeader", value.requestHeader, RequestHeader.class);
            encoder.writeBuiltinStruct("ClientDescription", value.clientDescription, ApplicationDescription.class);
            encoder.writeString("ServerUri", value.serverUri);
            encoder.writeString("EndpointUrl", value.endpointUrl);
            encoder.writeString("SessionName", value.sessionName);
            encoder.writeByteString("ClientNonce", value.clientNonce);
            encoder.writeByteString("ClientCertificate", value.clientCertificate);
            encoder.writeDouble("RequestedSessionTimeout", value.requestedSessionTimeout);
            encoder.writeUInt32("MaxResponseMessageSize", value.maxResponseMessageSize);
        }
    }
}

