/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;

public class CallMethodRequest
implements UaStructure {
    public static final NodeId TypeId = Identifiers.CallMethodRequest;
    public static final NodeId BinaryEncodingId = Identifiers.CallMethodRequest_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.CallMethodRequest_Encoding_DefaultXml;
    protected final NodeId objectId;
    protected final NodeId methodId;
    protected final Variant[] inputArguments;

    public CallMethodRequest() {
        this.objectId = null;
        this.methodId = null;
        this.inputArguments = null;
    }

    public CallMethodRequest(NodeId objectId, NodeId methodId, Variant[] inputArguments) {
        this.objectId = objectId;
        this.methodId = methodId;
        this.inputArguments = inputArguments;
    }

    public NodeId getObjectId() {
        return this.objectId;
    }

    public NodeId getMethodId() {
        return this.methodId;
    }

    @Nullable
    public Variant[] getInputArguments() {
        return this.inputArguments;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ObjectId", (Object)this.objectId).add("MethodId", (Object)this.methodId).add("InputArguments", (Object)this.inputArguments).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<CallMethodRequest> {
        @Override
        public Class<CallMethodRequest> getType() {
            return CallMethodRequest.class;
        }

        @Override
        public CallMethodRequest decode(UaDecoder decoder) throws UaSerializationException {
            NodeId objectId = decoder.readNodeId("ObjectId");
            NodeId methodId = decoder.readNodeId("MethodId");
            Variant[] inputArguments = decoder.readArray("InputArguments", decoder::readVariant, Variant.class);
            return new CallMethodRequest(objectId, methodId, inputArguments);
        }

        @Override
        public void encode(CallMethodRequest value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeNodeId("ObjectId", value.objectId);
            encoder.writeNodeId("MethodId", value.methodId);
            encoder.writeArray("InputArguments", value.inputArguments, encoder::writeVariant);
        }
    }
}

