/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.nodes.objects;

import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.AcknowledgeableConditionNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.ShelvedStateMachineNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.PropertyNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.TwoStateVariableNode;
import org.eclipse.milo.opcua.sdk.client.model.types.objects.AlarmConditionType;
import org.eclipse.milo.opcua.sdk.client.nodes.UaVariableNode;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;

public class AlarmConditionNode
extends AcknowledgeableConditionNode
implements AlarmConditionType {
    public AlarmConditionNode(OpcUaClient client, NodeId nodeId) {
        super(client, nodeId);
    }

    public CompletableFuture<PropertyNode> getInputNodeNode() {
        return this.getPropertyNode(AlarmConditionType.INPUT_NODE);
    }

    @Override
    public CompletableFuture<NodeId> getInputNode() {
        return this.getProperty(AlarmConditionType.INPUT_NODE);
    }

    @Override
    public CompletableFuture<StatusCode> setInputNode(NodeId value) {
        return this.setProperty(AlarmConditionType.INPUT_NODE, value);
    }

    public CompletableFuture<PropertyNode> getSuppressedOrShelvedNode() {
        return this.getPropertyNode(AlarmConditionType.SUPPRESSED_OR_SHELVED);
    }

    @Override
    public CompletableFuture<Boolean> getSuppressedOrShelved() {
        return this.getProperty(AlarmConditionType.SUPPRESSED_OR_SHELVED);
    }

    @Override
    public CompletableFuture<StatusCode> setSuppressedOrShelved(Boolean value) {
        return this.setProperty(AlarmConditionType.SUPPRESSED_OR_SHELVED, value);
    }

    public CompletableFuture<PropertyNode> getMaxTimeShelvedNode() {
        return this.getPropertyNode(AlarmConditionType.MAX_TIME_SHELVED);
    }

    @Override
    public CompletableFuture<Double> getMaxTimeShelved() {
        return this.getProperty(AlarmConditionType.MAX_TIME_SHELVED);
    }

    @Override
    public CompletableFuture<StatusCode> setMaxTimeShelved(Double value) {
        return this.setProperty(AlarmConditionType.MAX_TIME_SHELVED, value);
    }

    @Override
    public CompletableFuture<TwoStateVariableNode> getEnabledStateNode() {
        return this.getVariableComponent("http://opcfoundation.org/UA/", "EnabledState").thenApply(TwoStateVariableNode.class::cast);
    }

    @Override
    public CompletableFuture<LocalizedText> getEnabledState() {
        return ((CompletableFuture)this.getEnabledStateNode().thenCompose(UaVariableNode::getValue)).thenApply(o -> this.cast(o, LocalizedText.class));
    }

    @Override
    public CompletableFuture<StatusCode> setEnabledState(LocalizedText value) {
        return this.getEnabledStateNode().thenCompose(node -> node.setValue(value));
    }

    public CompletableFuture<TwoStateVariableNode> getActiveStateNode() {
        return this.getVariableComponent("http://opcfoundation.org/UA/", "ActiveState").thenApply(TwoStateVariableNode.class::cast);
    }

    @Override
    public CompletableFuture<LocalizedText> getActiveState() {
        return ((CompletableFuture)this.getActiveStateNode().thenCompose(UaVariableNode::getValue)).thenApply(o -> this.cast(o, LocalizedText.class));
    }

    @Override
    public CompletableFuture<StatusCode> setActiveState(LocalizedText value) {
        return this.getActiveStateNode().thenCompose(node -> node.setValue(value));
    }

    public CompletableFuture<TwoStateVariableNode> getSuppressedStateNode() {
        return this.getVariableComponent("http://opcfoundation.org/UA/", "SuppressedState").thenApply(TwoStateVariableNode.class::cast);
    }

    @Override
    public CompletableFuture<LocalizedText> getSuppressedState() {
        return ((CompletableFuture)this.getSuppressedStateNode().thenCompose(UaVariableNode::getValue)).thenApply(o -> this.cast(o, LocalizedText.class));
    }

    @Override
    public CompletableFuture<StatusCode> setSuppressedState(LocalizedText value) {
        return this.getSuppressedStateNode().thenCompose(node -> node.setValue(value));
    }

    public CompletableFuture<ShelvedStateMachineNode> getShelvingStateNode() {
        return this.getObjectComponent("http://opcfoundation.org/UA/", "ShelvingState").thenApply(ShelvedStateMachineNode.class::cast);
    }
}

