/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.nodes;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.sdk.core.AccessLevel;
import org.eclipse.milo.opcua.sdk.core.QualifiedProperty;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.core.util.StreamUtil;
import org.eclipse.milo.opcua.sdk.server.api.nodes.Node;
import org.eclipse.milo.opcua.sdk.server.api.nodes.ObjectNode;
import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNodeContext;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.EUInformation;
import org.eclipse.milo.opcua.stack.core.types.structured.TimeZoneDataType;

public class UaVariableNode
extends UaNode
implements VariableNode {
    private static final DataValue INITIAL_VALUE = new DataValue(new StatusCode(1083310080L));
    private volatile DataValue value = INITIAL_VALUE;
    private volatile NodeId dataType = Identifiers.BaseDataType;
    private volatile Integer valueRank = -1;
    private volatile UInteger[] arrayDimensions = null;
    private volatile UByte accessLevel = Unsigned.ubyte((int)AccessLevel.getMask((AccessLevel[])new AccessLevel[]{AccessLevel.CurrentRead}));
    private volatile UByte userAccessLevel = Unsigned.ubyte((int)AccessLevel.getMask((AccessLevel[])new AccessLevel[]{AccessLevel.CurrentRead}));
    private volatile Double minimumSamplingInterval = 0.0;
    private volatile Boolean historizing = false;
    public static final QualifiedProperty<String> NodeVersion = new QualifiedProperty("http://opcfoundation.org/UA/", "NodeVersion", Identifiers.String, Integer.valueOf(-1), String.class);
    public static final QualifiedProperty<TimeZoneDataType> LocalTime = new QualifiedProperty("http://opcfoundation.org/UA/", "LocalTime", Identifiers.TimeZoneDataType, Integer.valueOf(-1), TimeZoneDataType.class);
    public static final QualifiedProperty<String> DataTypeVersion = new QualifiedProperty("http://opcfoundation.org/UA/", "DataTypeVersion", Identifiers.String, Integer.valueOf(-1), String.class);
    public static final QualifiedProperty<ByteString> DictionaryFragment = new QualifiedProperty("http://opcfoundation.org/UA/", "DictionaryFragment", Identifiers.ByteString, Integer.valueOf(-1), ByteString.class);
    public static final QualifiedProperty<Boolean> AllowNulls = new QualifiedProperty("http://opcfoundation.org/UA/", "AllowNulls", Identifiers.Boolean, Integer.valueOf(-1), Boolean.class);
    public static final QualifiedProperty<LocalizedText> ValueAsText = new QualifiedProperty("http://opcfoundation.org/UA/", "ValueAsText", Identifiers.LocalizedText, Integer.valueOf(-1), LocalizedText.class);
    public static final QualifiedProperty<UInteger> MaxStringLength = new QualifiedProperty("http://opcfoundation.org/UA/", "MaxStringLength", Identifiers.UInt32, Integer.valueOf(-1), UInteger.class);
    public static final QualifiedProperty<UInteger> MaxArrayLength = new QualifiedProperty("http://opcfoundation.org/UA/", "MaxArrayLength", Identifiers.UInt32, Integer.valueOf(-1), UInteger.class);
    public static final QualifiedProperty<EUInformation> EngineeringUnits = new QualifiedProperty("http://opcfoundation.org/UA/", "EngineeringUnits", Identifiers.EUInformation, Integer.valueOf(-1), EUInformation.class);

    public UaVariableNode(UaNodeContext context, NodeId nodeId, VariableTypeNode variableTypeNode) {
        this(context, nodeId, variableTypeNode.getBrowseName(), variableTypeNode.getDisplayName());
        this.setDescription(variableTypeNode.getDescription());
        this.setWriteMask(variableTypeNode.getWriteMask());
        this.setUserWriteMask(variableTypeNode.getUserWriteMask());
        this.setValue(variableTypeNode.getValue());
        this.setDataType(variableTypeNode.getDataType());
        this.setValueRank(variableTypeNode.getValueRank());
        this.setArrayDimensions(variableTypeNode.getArrayDimensions());
    }

    public UaVariableNode(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName) {
        super(context, nodeId, NodeClass.Variable, browseName, displayName);
    }

    public UaVariableNode(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask) {
        super(context, nodeId, NodeClass.Variable, browseName, displayName, description, writeMask, userWriteMask);
    }

    public UaVariableNode(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, DataValue value, NodeId dataType, Integer valueRank, UInteger[] arrayDimensions, UByte accessLevel, UByte userAccessLevel, Double minimumSamplingInterval, boolean historizing) {
        super(context, nodeId, NodeClass.Variable, browseName, displayName, description, writeMask, userWriteMask);
        this.value = value;
        this.dataType = dataType;
        this.valueRank = valueRank;
        this.arrayDimensions = arrayDimensions;
        this.accessLevel = accessLevel;
        this.userAccessLevel = userAccessLevel;
        this.minimumSamplingInterval = minimumSamplingInterval;
        this.historizing = historizing;
    }

    @Override
    public DataValue getValue() {
        return this.value;
    }

    @Override
    public NodeId getDataType() {
        return this.dataType;
    }

    @Override
    public Integer getValueRank() {
        return this.valueRank;
    }

    @Override
    public UInteger[] getArrayDimensions() {
        return this.arrayDimensions;
    }

    @Override
    public UByte getAccessLevel() {
        return this.accessLevel;
    }

    @Override
    public UByte getUserAccessLevel() {
        return this.userAccessLevel;
    }

    @Override
    public Double getMinimumSamplingInterval() {
        return this.minimumSamplingInterval;
    }

    @Override
    public Boolean getHistorizing() {
        return this.historizing;
    }

    @Override
    public synchronized void setValue(DataValue value) {
        this.value = value;
        this.fireAttributeChanged(AttributeId.Value, value);
    }

    @Override
    public synchronized void setDataType(NodeId dataType) {
        this.dataType = dataType;
        this.fireAttributeChanged(AttributeId.DataType, dataType);
    }

    @Override
    public synchronized void setValueRank(Integer valueRank) {
        this.valueRank = valueRank;
        this.fireAttributeChanged(AttributeId.ValueRank, valueRank);
    }

    @Override
    public synchronized void setArrayDimensions(UInteger[] arrayDimensions) {
        this.arrayDimensions = arrayDimensions;
        this.fireAttributeChanged(AttributeId.ArrayDimensions, arrayDimensions);
    }

    @Override
    public synchronized void setAccessLevel(UByte accessLevel) {
        this.accessLevel = accessLevel;
        this.fireAttributeChanged(AttributeId.AccessLevel, accessLevel);
    }

    @Override
    public synchronized void setUserAccessLevel(UByte userAccessLevel) {
        this.userAccessLevel = userAccessLevel;
        this.fireAttributeChanged(AttributeId.UserAccessLevel, userAccessLevel);
    }

    @Override
    public void setMinimumSamplingInterval(Double minimumSamplingInterval) {
        this.minimumSamplingInterval = minimumSamplingInterval;
        this.fireAttributeChanged(AttributeId.MinimumSamplingInterval, minimumSamplingInterval);
    }

    @Override
    public void setHistorizing(Boolean historizing) {
        this.historizing = historizing;
        this.fireAttributeChanged(AttributeId.Historizing, historizing);
    }

    public Optional<ObjectNode> getModellingRuleNode() {
        Node node = this.getReferences().stream().filter(Reference.HAS_MODELLING_RULE_PREDICATE).findFirst().flatMap(r -> this.getManagedNode(r.getTargetNodeId())).orElse(null);
        ObjectNode objectNode = node instanceof ObjectNode ? (ObjectNode)node : null;
        return Optional.ofNullable(objectNode);
    }

    public List<Node> getPropertyNodes() {
        return this.getReferences().stream().filter(Reference.HAS_PROPERTY_PREDICATE).flatMap(r -> StreamUtil.opt2stream(this.getManagedNode(r.getTargetNodeId()))).collect(Collectors.toList());
    }

    public List<Node> getComponentNodes() {
        return this.getReferences().stream().filter(Reference.HAS_COMPONENT_PREDICATE).flatMap(r -> StreamUtil.opt2stream(this.getManagedNode(r.getTargetNodeId()))).collect(Collectors.toList());
    }

    public VariableTypeNode getTypeDefinitionNode() {
        Node node = this.getReferences().stream().filter(Reference.HAS_TYPE_DEFINITION_PREDICATE).findFirst().flatMap(r -> this.getManagedNode(r.getTargetNodeId())).orElse(null);
        return node instanceof VariableTypeNode ? (VariableTypeNode)node : null;
    }

    public void addComponent(UaNode node) {
        this.addReference(new Reference(this.getNodeId(), Identifiers.HasComponent, node.getNodeId().expanded(), true));
    }

    public void removeComponent(UaNode node) {
        this.removeReference(new Reference(this.getNodeId(), Identifiers.HasComponent, node.getNodeId().expanded(), true));
    }

    @Nullable
    public String getNodeVersion() {
        return this.getProperty(NodeVersion).orElse(null);
    }

    @Nullable
    public TimeZoneDataType getLocalTime() {
        return this.getProperty(LocalTime).orElse(null);
    }

    @Nullable
    public String getDataTypeVersion() {
        return this.getProperty(DataTypeVersion).orElse(null);
    }

    @Nullable
    public ByteString getDictionaryFragment() {
        return this.getProperty(DictionaryFragment).orElse(null);
    }

    @Nullable
    public Boolean getAllowNulls() {
        return this.getProperty(AllowNulls).orElse(null);
    }

    @Nullable
    public UInteger getMaxStringLength() {
        return this.getProperty(MaxStringLength).orElse(null);
    }

    @Nullable
    public UInteger getMaxArrayLength() {
        return this.getProperty(MaxArrayLength).orElse(null);
    }

    @Nullable
    public EUInformation getEngineeringUnits() {
        return this.getProperty(EngineeringUnits).orElse(null);
    }

    public void setNodeVersion(String nodeVersion) {
        this.setProperty(NodeVersion, nodeVersion);
    }

    public void setLocalTime(TimeZoneDataType localTime) {
        this.setProperty(LocalTime, localTime);
    }

    public void setDataTypeVersion(String dataTypeVersion) {
        this.setProperty(DataTypeVersion, dataTypeVersion);
    }

    public void setDictionaryFragment(ByteString dictionaryFragment) {
        this.setProperty(DictionaryFragment, dictionaryFragment);
    }

    public void setAllowNulls(Boolean allowNulls) {
        this.setProperty(AllowNulls, allowNulls);
    }

    public void setMaxStringLength(UInteger maxStringLength) {
        this.setProperty(MaxStringLength, maxStringLength);
    }

    public void setMaxArrayLength(UInteger maxArrayLength) {
        this.setProperty(MaxArrayLength, maxArrayLength);
    }

    public void setEngineeringUnits(EUInformation engineeringUnits) {
        this.setProperty(EngineeringUnits, engineeringUnits);
    }

    public static UaVariableNodeBuilder builder(UaNodeContext context) {
        return new UaVariableNodeBuilder(context);
    }

    public static class UaVariableNodeBuilder
    implements Supplier<UaVariableNode> {
        private final List<Reference> references = Lists.newArrayList();
        private NodeId nodeId;
        private QualifiedName browseName;
        private LocalizedText displayName;
        private LocalizedText description = LocalizedText.NULL_VALUE;
        private UInteger writeMask = UInteger.MIN;
        private UInteger userWriteMask = UInteger.MIN;
        private DataValue value = new DataValue(Variant.NULL_VALUE, new StatusCode(1083310080L), DateTime.now(), DateTime.now());
        private NodeId dataType;
        private int valueRank = -1;
        private UInteger[] arrayDimensions = null;
        private UByte accessLevel = Unsigned.ubyte((int)AccessLevel.getMask((AccessLevel[])new AccessLevel[]{AccessLevel.CurrentRead}));
        private UByte userAccessLevel = Unsigned.ubyte((int)AccessLevel.getMask((AccessLevel[])new AccessLevel[]{AccessLevel.CurrentRead}));
        private Double minimumSamplingInterval = 0.0;
        private boolean historizing = false;
        private final UaNodeContext context;

        public UaVariableNodeBuilder(UaNodeContext context) {
            this.context = context;
        }

        @Override
        public UaVariableNode get() {
            return this.build();
        }

        public UaVariableNode build() {
            Preconditions.checkNotNull((Object)this.nodeId, (Object)"NodeId cannot be null");
            Preconditions.checkNotNull((Object)this.browseName, (Object)"BrowseName cannot be null");
            Preconditions.checkNotNull((Object)this.displayName, (Object)"DisplayName cannot be null");
            Preconditions.checkNotNull((Object)this.dataType, (Object)"DataType cannot be null");
            long hasTypeDefinitionCount = this.references.stream().filter(r -> Identifiers.HasTypeDefinition.equals((Object)r.getReferenceTypeId())).count();
            if (hasTypeDefinitionCount == 0L) {
                this.setTypeDefinition(Identifiers.BaseDataVariableType);
            } else {
                Preconditions.checkState((hasTypeDefinitionCount == 1L ? 1 : 0) != 0, (Object)"Variable Node must have exactly one HasTypeDefinition reference.");
            }
            UaVariableNode node = new UaVariableNode(this.context, this.nodeId, this.browseName, this.displayName, this.description, this.writeMask, this.userWriteMask, this.value, this.dataType, this.valueRank, this.arrayDimensions, this.accessLevel, this.userAccessLevel, this.minimumSamplingInterval, this.historizing);
            this.references.forEach(node::addReference);
            return node;
        }

        public UaVariableNodeBuilder setNodeId(NodeId nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public UaVariableNodeBuilder setBrowseName(QualifiedName browseName) {
            this.browseName = browseName;
            return this;
        }

        public UaVariableNodeBuilder setDisplayName(LocalizedText displayName) {
            this.displayName = displayName;
            return this;
        }

        public UaVariableNodeBuilder setDescription(LocalizedText description) {
            this.description = description;
            return this;
        }

        public UaVariableNodeBuilder setWriteMask(UInteger writeMask) {
            this.writeMask = writeMask;
            return this;
        }

        public UaVariableNodeBuilder setUserWriteMask(UInteger userWriteMask) {
            this.userWriteMask = userWriteMask;
            return this;
        }

        public UaVariableNodeBuilder setValue(DataValue value) {
            this.value = value;
            return this;
        }

        public UaVariableNodeBuilder setDataType(NodeId dataType) {
            this.dataType = dataType;
            return this;
        }

        public UaVariableNodeBuilder setValueRank(int valueRank) {
            this.valueRank = valueRank;
            return this;
        }

        public UaVariableNodeBuilder setArrayDimensions(UInteger[] arrayDimensions) {
            this.arrayDimensions = arrayDimensions;
            return this;
        }

        public UaVariableNodeBuilder setAccessLevel(UByte accessLevel) {
            this.accessLevel = accessLevel;
            return this;
        }

        public UaVariableNodeBuilder setUserAccessLevel(UByte userAccessLevel) {
            this.userAccessLevel = userAccessLevel;
            return this;
        }

        public UaVariableNodeBuilder setMinimumSamplingInterval(Double minimumSamplingInterval) {
            this.minimumSamplingInterval = minimumSamplingInterval;
            return this;
        }

        public UaVariableNodeBuilder setHistorizing(boolean historizing) {
            this.historizing = historizing;
            return this;
        }

        public UaVariableNodeBuilder addReference(Reference reference) {
            this.references.add(reference);
            return this;
        }

        public UaVariableNodeBuilder setTypeDefinition(NodeId typeDefinition) {
            Objects.requireNonNull(this.nodeId, "NodeId cannot be null");
            this.references.add(new Reference(this.nodeId, Identifiers.HasTypeDefinition, new ExpandedNodeId(typeDefinition), true));
            return this;
        }
    }
}

