/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoringParameters;

public class MonitoredItemModifyRequest
implements UaStructure {
    public static final NodeId TypeId = Identifiers.MonitoredItemModifyRequest;
    public static final NodeId BinaryEncodingId = Identifiers.MonitoredItemModifyRequest_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.MonitoredItemModifyRequest_Encoding_DefaultXml;
    protected final UInteger monitoredItemId;
    protected final MonitoringParameters requestedParameters;

    public MonitoredItemModifyRequest() {
        this.monitoredItemId = null;
        this.requestedParameters = null;
    }

    public MonitoredItemModifyRequest(UInteger monitoredItemId, MonitoringParameters requestedParameters) {
        this.monitoredItemId = monitoredItemId;
        this.requestedParameters = requestedParameters;
    }

    public UInteger getMonitoredItemId() {
        return this.monitoredItemId;
    }

    public MonitoringParameters getRequestedParameters() {
        return this.requestedParameters;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("MonitoredItemId", (Object)this.monitoredItemId).add("RequestedParameters", (Object)this.requestedParameters).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<MonitoredItemModifyRequest> {
        @Override
        public Class<MonitoredItemModifyRequest> getType() {
            return MonitoredItemModifyRequest.class;
        }

        @Override
        public MonitoredItemModifyRequest decode(UaDecoder decoder) throws UaSerializationException {
            UInteger monitoredItemId = decoder.readUInt32("MonitoredItemId");
            MonitoringParameters requestedParameters = decoder.readBuiltinStruct("RequestedParameters", MonitoringParameters.class);
            return new MonitoredItemModifyRequest(monitoredItemId, requestedParameters);
        }

        @Override
        public void encode(MonitoredItemModifyRequest value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeUInt32("MonitoredItemId", value.monitoredItemId);
            encoder.writeBuiltinStruct("RequestedParameters", value.requestedParameters, MonitoringParameters.class);
        }
    }
}

