/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;

public class HistoryData
implements UaStructure {
    public static final NodeId TypeId = Identifiers.HistoryData;
    public static final NodeId BinaryEncodingId = Identifiers.HistoryData_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.HistoryData_Encoding_DefaultXml;
    protected final DataValue[] dataValues;

    public HistoryData() {
        this.dataValues = null;
    }

    public HistoryData(DataValue[] dataValues) {
        this.dataValues = dataValues;
    }

    @Nullable
    public DataValue[] getDataValues() {
        return this.dataValues;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("DataValues", (Object)this.dataValues).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<HistoryData> {
        @Override
        public Class<HistoryData> getType() {
            return HistoryData.class;
        }

        @Override
        public HistoryData decode(UaDecoder decoder) throws UaSerializationException {
            DataValue[] dataValues = decoder.readArray("DataValues", decoder::readDataValue, DataValue.class);
            return new HistoryData(dataValues);
        }

        @Override
        public void encode(HistoryData value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeArray("DataValues", value.dataValues, encoder::writeDataValue);
        }
    }
}

